/**
 * @(#) CargoStorageDetailQueryRespDto.java 1.0 2018-09-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 管理端：货品库存查询响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageDetailQueryRespDto", description = "管理端：货品库存查询响应Dto")
public class CargoStorageDetailQueryRespDto extends BaseVo {
    /**
     * 货品库存ID
     */
    @ApiModelProperty(name = "id", value = "货品库存ID")
    private Long id;
    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "positionId", value = "仓位ID")
    private Long positionId;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 总库存
     */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
     * 待分配
     */
    @ApiModelProperty(name = "allocate", value = "待分配")
    private BigDecimal allocate;
    /**
     * 预占用
     */
    @ApiModelProperty(name = "appending", value = "预占用")
    private BigDecimal appending;
    /**
     * 在途(调拨)
     */
    @ApiModelProperty(name = "intransit", value = "在途(调拨)")
    private BigDecimal intransit;
    /**
     * 预售
     */
    @ApiModelProperty(name = "presell", value = "预售")
    private BigDecimal presell;
    /**
     * 活动库存
     */
    @ApiModelProperty(name = "activity", value = "活动库存")
    private BigDecimal activity;
    /**
     * 残次品
     */
    @ApiModelProperty(name = "imperfections", value = "残次品")
    private BigDecimal imperfections;
    /**
     * 赔付品
     */
    @ApiModelProperty(name = "indemnity", value = "赔付品")
    private Long indemnity;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getAppending() {
        return appending;
    }

    public void setAppending(BigDecimal appending) {
        this.appending = appending;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getPresell() {
        return presell;
    }

    public void setPresell(BigDecimal presell) {
        this.presell = presell;
    }

    public BigDecimal getActivity() {
        return activity;
    }

    public void setActivity(BigDecimal activity) {
        this.activity = activity;
    }

    public BigDecimal getImperfections() {
        return imperfections;
    }

    public void setImperfections(BigDecimal imperfections) {
        this.imperfections = imperfections;
    }

    public Long getIndemnity() {
        return indemnity;
    }

    public void setIndemnity(Long indemnity) {
        this.indemnity = indemnity;
    }
}
