/**
 * @(#) CargoStorageInfoQueryRespDto.java 1.0 2018-09-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 消费端：货品可用库存查询响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageInfoQueryRespDto", description = "消费端：货品可用库存查询响应Dto")
public class CargoStorageInfoQueryRespDto extends BaseVo {

    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 货品数目 (可用库存)
     */
    @ApiModelProperty(name = "num", value = "货品数目")
    private BigDecimal num;


    /**
     * 库存总数
     */
    @ApiModelProperty(name = "balance", value = "库存总数")
    private BigDecimal balance;

    /**
     * 预占
     */
    @ApiModelProperty(name = "preempt", value = "预占")
    private BigDecimal preempt;

    /**
     * 可用
     */
    @ApiModelProperty(name = "available", value = "可用")
    private BigDecimal available;

    /**
     * 货品code
     */
    @ApiModelProperty(name = "cargoCode", value = "货品code")
    private String cargoCode;

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
}
