/*
 * @(#) DeliveryItemRespDto.java 1.0 2018-11-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 发货商品明细
 *
 * @author 浮云
 */
@ApiModel(value = "DeliveryItemRespDto", description = "应发商品明细")
public class DeliveryItemRespDto extends BaseVo {

    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "tradeNo", value = "交易流水号")
    private String tradeNo;
    /**
     * 所属发货记录流水号
     */
    @ApiModelProperty(name = "deliveryNo", value = "所属发货记录流水号")
    private String deliveryNo;
    /**
     * 订单商品明细id
     */
    @ApiModelProperty(name = "trOrderItemNo", value = "订单商品明细id")
    private String trOrderItemNo;
    /**
     * 发货类型
     * 普通发送,发补发, 换货重发
     */
    @ApiModelProperty(name = "deliveryType", value = "发货类型普通发送,发补发,换货重发")
    private String deliveryType;
    /**
     * 发货小类
     * 比如补发 ,可以是漏发的补发,  损坏的补发,
     * 一般可不使用
     */
    @ApiModelProperty(name = "deliverySubType", value = "发货小类比如补发,可以是漏发的补发,损坏的补发,一般可不使用")
    private String deliverySubType;
    /**
     * 数量
     */
    @ApiModelProperty(name = "itemNum", value = "数量")
    private Integer itemNum;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoSerial", value = "货品编码")
    private String cargoSerial;


    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return this.deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getTrOrderItemNo() {
        return this.trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public String getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliverySubType() {
        return this.deliverySubType;
    }

    public void setDeliverySubType(String deliverySubType) {
        this.deliverySubType = deliverySubType;
    }

    public Integer getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }


    public String getCargoSerial() {
        return this.cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }


}