/**
 * @(#) DeliveryOrderQueryRespDto.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.DeliveryOrderDetailDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 发货单查询响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DeliveryOrderQueryRespDto", description = "发货单查询响应Dto")
public class DeliveryOrderQueryRespDto extends BaseVo {
    /**
     * 发货单ID
     */
    @ApiModelProperty(name = "id", value = "发货单ID")
    private Long id;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 发货单编号
     */
    @ApiModelProperty(name = "deliveryOrderNo", value = "发货单编号")
    private String deliveryOrderNo;
    /**
     * 交易订单ID
     */
    @ApiModelProperty(name = "orderId", value = "交易订单ID")
    private Long orderId;
    /**
     * 交易订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "交易订单编号")
    private String orderNo;
    /**
     * 交易单状态
     */
    @ApiModelProperty(name = "status", value = "交易单状态")
    private String status;
    /**
     * 交易单明细集合
     */
    @ApiModelProperty(name = "deliveryOrderDetailDtoList", value = "交易单明细集合")
    private List<DeliveryOrderDetailDto> deliveryOrderDetailDtoList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<DeliveryOrderDetailDto> getDeliveryOrderDetailDtoList() {
        return deliveryOrderDetailDtoList;
    }

    public void setDeliveryOrderDetailDtoList(List<DeliveryOrderDetailDto> deliveryOrderDetailDtoList) {
        this.deliveryOrderDetailDtoList = deliveryOrderDetailDtoList;
    }
}
