package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 发货单路由拆单结果dto
 *
 * @author: fuyun
 */
@ApiModel(value = "DeliveryRouteSplitRespDto", description = "发货单路由拆单结果dto")
public class DeliveryRouteSplitRespDto {

    public DeliveryRouteSplitRespDto() {
    }

    public DeliveryRouteSplitRespDto(Long warehouseId, String warehouseCode, String warehouseName, Integer warehouseSubType, String cargoCode, Integer itemNum, Long warehouseOrganizationId, String warehouseOrganizationName) {
        this.warehouseId = warehouseId;
        this.warehouseCode = warehouseCode;
        this.warehouseName = warehouseName;
        this.warehouseSubType = warehouseSubType;
        this.cargoCode = cargoCode;
        this.itemNum = itemNum;
        this.warehouseOrganizationId = warehouseOrganizationId;
        this.warehouseOrganizationName = warehouseOrganizationName;
    }

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "warehouseSubType", value = "仓库子类型")
    private Integer warehouseSubType;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "itemNum", value = "数量")
    private Integer itemNum;

    /**
     * 路由仓库对应的所属组织ID
     */
    @ApiModelProperty(name = "warehouseOrganizationId")
    private Long warehouseOrganizationId;

    /**
     * 路由仓库对应的所属组织名称
     */
    @ApiModelProperty(name = "warehouseOrganizationName")
    private String warehouseOrganizationName;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Integer getWarehouseSubType() {
        return warehouseSubType;
    }

    public void setWarehouseSubType(Integer warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getWarehouseOrganizationId() {
        return warehouseOrganizationId;
    }

    public void setWarehouseOrganizationId(Long warehouseOrganizationId) {
        this.warehouseOrganizationId = warehouseOrganizationId;
    }

    public String getWarehouseOrganizationName() {
        return warehouseOrganizationName;
    }

    public void setWarehouseOrganizationName(String warehouseOrganizationName) {
        this.warehouseOrganizationName = warehouseOrganizationName;
    }
}
