package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author: pengbo
 * @Date: 2020-12-24 10:50
 * @since 2.0.0
 */
@ApiModel(value = "InventorySettingReqDto", description = "库存设置")
public class InventorySettingReqDto extends BaseVo {

    @ApiModelProperty(name = "storeSafetyInventoryStrategyDto", value = "安全库存策略设置")
    @NotNull
    private StoreSafetyInventoryStrategyDto storeSafetyInventoryStrategyDto;

    @ApiModelProperty(name = "inventoryCalculateDto", value = "库存计算设置")
    @NotNull
    private InventoryCalculateDto inventoryCalculateDto;

    @ApiModelProperty(name = "InventoryBaseDto", value = "库存计算设置")
    @NotNull
    private InventoryBaseDto inventoryBaseDto;


    public InventoryCalculateDto getInventoryCalculateDto() {
        return inventoryCalculateDto;
    }

    public void setInventoryCalculateDto(InventoryCalculateDto inventoryCalculateDto) {
        this.inventoryCalculateDto = inventoryCalculateDto;
    }


    @ApiModel(value = "StoreSafetyInventoryStrategyDto", description = "安全库存策略")
    public static class StoreSafetyInventoryStrategyDto implements Serializable {
        @ApiModelProperty(name = "safetyInventorOverNum", value = "防超卖安全库存数量")
        private Integer safetyInventorOverNum;

        @ApiModelProperty(name = "singleChannelInventorOverNum", value = "单渠道安全共享库存")
        private Integer singleChannelInventorOverNum;

        @ApiModelProperty(name = "singleChannelCode", value = "单渠道共享编码")
        private String singleChannelCode;

        public Integer getSafetyInventorOverNum() {
            return safetyInventorOverNum;
        }

        public void setSafetyInventorOverNum(Integer safetyInventorOverNum) {
            this.safetyInventorOverNum = safetyInventorOverNum;
        }

        public Integer getSingleChannelInventorOverNum() {
            return singleChannelInventorOverNum;
        }

        public void setSingleChannelInventorOverNum(Integer singleChannelInventorOverNum) {
            this.singleChannelInventorOverNum = singleChannelInventorOverNum;
        }

        public String getSingleChannelCode() {
            return singleChannelCode;
        }

        public void setSingleChannelCode(String singleChannelCode) {
            this.singleChannelCode = singleChannelCode;
        }
    }

    @ApiModel(value = "InventoryCalculateDto", description = "库存计算")
    public static class InventoryCalculateDto implements Serializable {
        @ApiModelProperty(name = "frequencyNum", value = "库存计算频率")
        private Integer frequencyNum;

        public Integer getFrequencyNum() {
            return frequencyNum;
        }

        public void setFrequencyNum(Integer frequencyNum) {
            this.frequencyNum = frequencyNum;
        }
    }

    @ApiModel(value = "InventoryBaseDto", description = "库存基础设置")
    public static class InventoryBaseDto implements Serializable {

        @ApiModelProperty(name = "batchStatus", value = "批次状态 0禁用 1启用 ")
        private Integer batchStatus;
        @ApiModelProperty(name = "outBoundRule", value = "出库规则设置  1 先进先出，2近郊先出  ")
        private Integer outBoundRule;
        @ApiModelProperty(name = "inventoryWarnCycle", value = "库存预警周期")
        private Integer inventoryWarnCycle;
        @ApiModelProperty(name = "inventoryTight", value = "库存紧张")
        private BigDecimal inventoryTight;
        @ApiModelProperty(name = "inventoryAdequate", value = "库存充足")
        private BigDecimal inventoryAdequate;

        public Integer getBatchStatus() {
            return batchStatus;
        }

        public void setBatchStatus(Integer batchStatus) {
            this.batchStatus = batchStatus;
        }

        public Integer getOutBoundRule() {
            return outBoundRule;
        }

        public void setOutBoundRule(Integer outBoundRule) {
            this.outBoundRule = outBoundRule;
        }

        public Integer getInventoryWarnCycle() {
            return inventoryWarnCycle;
        }

        public void setInventoryWarnCycle(Integer inventoryWarnCycle) {
            this.inventoryWarnCycle = inventoryWarnCycle;
        }

        public BigDecimal getInventoryTight() {
            return inventoryTight;
        }

        public void setInventoryTight(BigDecimal inventoryTight) {
            this.inventoryTight = inventoryTight;
        }

        public BigDecimal getInventoryAdequate() {
            return inventoryAdequate;
        }

        public void setInventoryAdequate(BigDecimal inventoryAdequate) {
            this.inventoryAdequate = inventoryAdequate;
        }
    }


    public StoreSafetyInventoryStrategyDto getStoreSafetyInventoryStrategyDto() {
        return storeSafetyInventoryStrategyDto;
    }

    public void setStoreSafetyInventoryStrategyDto(StoreSafetyInventoryStrategyDto storeSafetyInventoryStrategyDto) {
        this.storeSafetyInventoryStrategyDto = storeSafetyInventoryStrategyDto;
    }

    public InventoryBaseDto getInventoryBaseDto() {
        return inventoryBaseDto;
    }

    public void setInventoryBaseDto(InventoryBaseDto inventoryBaseDto) {
        this.inventoryBaseDto = inventoryBaseDto;
    }
}
