package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author: liuji
 * @Date: 2020-06-22 14:21
 * @since 2.0.0
 */
@ApiModel(value = "OrderRouteRuleRespDto", description = "订单路由规则响应Dto")
public class OrderRouteRuleRespDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    @ApiModelProperty(name = "routeRuleName", value = "路由规则名称")
    private String routeRuleName;

    @ApiModelProperty(name = "applicableChannel", value = "适用渠道")
    private String applicableChannel;

    @ApiModelProperty(name = "routeType", value = "路由类型")
    private String routeType;

    @ApiModelProperty(name = "routeStatus", value = "路由状态（0 启用，1 禁用）")
    private Integer routeStatus;

    @ApiModelProperty(name = "splitFlag", value = "是否拆单（0 拆单，1 不拆单）")
    private Integer splitFlag;

    @ApiModelProperty(name = "giftDeliveryWarehouse", value = "赠品发货仓库")
    private String giftDeliveryWarehouse;

    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货仓库编码")
    private String deliveryWarehouseCode;

    @ApiModelProperty(name = "inventoryPriority", value = "库存优先级（0 库存优先，1 路由得分优先）")
    private Integer inventoryPriority;

    @ApiModelProperty(name = "inventoryPriorityItem", value = "库存规则信息（json格式存放）[\"0\",\"1\",\"2\"]")
    private String inventoryPriorityItem;

    @ApiModelProperty(name = "weightItem", value = "规则因素信息（json格式存放权重项）[{\"type\":\"0\",\"ration\":40,\"id\":\"1\"},{\"type\":\"1\",\"ration\":30,\"id\":\"1575853392564\"}]")
    private String weightItem;

    @ApiModelProperty(name = "extension", value = "扩展值")
    private String extension;

    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRouteRuleName() {
        return routeRuleName;
    }

    public void setRouteRuleName(String routeRuleName) {
        this.routeRuleName = routeRuleName;
    }

    public String getApplicableChannel() {
        return applicableChannel;
    }

    public void setApplicableChannel(String applicableChannel) {
        this.applicableChannel = applicableChannel;
    }

    public String getRouteType() {
        return routeType;
    }

    public void setRouteType(String routeType) {
        this.routeType = routeType;
    }

    public Integer getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(Integer routeStatus) {
        this.routeStatus = routeStatus;
    }

    public Integer getSplitFlag() {
        return splitFlag;
    }

    public void setSplitFlag(Integer splitFlag) {
        this.splitFlag = splitFlag;
    }

    public String getGiftDeliveryWarehouse() {
        return giftDeliveryWarehouse;
    }

    public void setGiftDeliveryWarehouse(String giftDeliveryWarehouse) {
        this.giftDeliveryWarehouse = giftDeliveryWarehouse;
    }

    public Integer getInventoryPriority() {
        return inventoryPriority;
    }

    public void setInventoryPriority(Integer inventoryPriority) {
        this.inventoryPriority = inventoryPriority;
    }

    public String getInventoryPriorityItem() {
        return inventoryPriorityItem;
    }

    public void setInventoryPriorityItem(String inventoryPriorityItem) {
        this.inventoryPriorityItem = inventoryPriorityItem;
    }

    public String getWeightItem() {
        return weightItem;
    }

    public void setWeightItem(String weightItem) {
        this.weightItem = weightItem;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }
}
