/*
 * PositionQueryRespDto.class 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 仓位查询响应Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PositionQueryRespDto", description = "仓位查询响应Dto")
public class PositionQueryRespDto extends BaseVo {

    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "id", value = "仓位ID")
    private Long id;
    /**
     * 仓位编码
     */
    @ApiModelProperty(name = "code", value = "仓位编码")
    private String code;
    /**
     * 仓位名称
     */
    @ApiModelProperty(name = "name", value = "仓位名称")
    private String name;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * REAL 实体仓位   NETWORK网络仓位
     */
    @ApiModelProperty(name = "type", value = "REAL 实体仓位   NETWORK网络仓位")
    private String type;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

}
