package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 仓库关联表Dto对象
 */
@ApiModel(value = "RefWarehouseDto", description = "RefWarehouseDto对象")
public class RefWarehouseRespDto extends RequestDto {

    /**
     * 货品多仓库集合
     */
    private List<RefWarehouseRespDto> refWarehouseReqDtos;
    /**
     *
     */
    @ApiModelProperty(name = "id", value = "   ", allowEmptyValue = true)
    private Long id;

    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = " 货品ID  ", allowEmptyValue = true)
    private Long cargoId;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = " 货品编码  ", allowEmptyValue = true)
    private String cargoCode;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = " 货品名称  ", allowEmptyValue = true)
    private String cargoName;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = " 仓库ID  ", allowEmptyValue = true)
    private String warehouseId;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = " 仓库编码  ", allowEmptyValue = true)
    private String warehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = " 仓库名称  ", allowEmptyValue = true)
    private String warehouseName;

    /**
     * 0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓
     */
    @ApiModelProperty(name = "warehouseType", value = " 0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓  ", allowEmptyValue = true)
    private Integer warehouseType;

    /**
     * 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS
     */
    @ApiModelProperty(name = "warehouseSubType", value = " 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS  ", allowEmptyValue = true)
    private Integer warehouseSubType;

    /**
     * 关联仓库ID
     */
    @ApiModelProperty(name = "refWarehouseId", value = " 关联仓库ID  ", allowEmptyValue = true)
    private String refWarehouseId;

    /**
     * 关联仓库编码
     */
    @ApiModelProperty(name = "refWarehouseCode", value = " 关联仓库编码  ", allowEmptyValue = true)
    private String refWarehouseCode;

    /**
     * 关联仓库名称
     */
    @ApiModelProperty(name = "refWarehouseName", value = " 关联仓库名称  ", allowEmptyValue = true)
    private String refWarehouseName;

    /**
     * 0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓
     */
    @ApiModelProperty(name = "refWarehouseType", value = " 0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓  ", allowEmptyValue = true)
    private Integer refWarehouseType;

    /**
     * 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS
     */
    @ApiModelProperty(name = "refWarehouseSubType", value = " 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS  ", allowEmptyValue = true)
    private Integer refWarehouseSubType;

    /**
     * 1：仓库关联，2： 货品关联
     */
    @ApiModelProperty(name = "type", value = " 1：仓库关联，2： 货品关联  ", allowEmptyValue = true)
    private Integer type;

    /**
     * 比例
     */
    @ApiModelProperty(name = "proportion", value = " 比例  ", allowEmptyValue = true)
    private BigDecimal proportion;

    /**
     * 序号
     */
    @ApiModelProperty(name = "sort", value = " 序号  ", allowEmptyValue = true)
    private Integer sort;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ", allowEmptyValue = true)
    private String updatePerson;

    /**
     * 最近一次修改时间
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ", allowEmptyValue = true)
    private Date updateTime;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getCargoId() {
        return this.cargoId;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoCode() {
        return this.cargoCode;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoName() {
        return this.cargoName;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseCode() {
        return this.warehouseCode;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public void setWarehouseType(Integer warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Integer getWarehouseType() {
        return this.warehouseType;
    }

    public void setWarehouseSubType(Integer warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Integer getWarehouseSubType() {
        return this.warehouseSubType;
    }

    public void setRefWarehouseId(String refWarehouseId) {
        this.refWarehouseId = refWarehouseId;
    }

    public String getRefWarehouseId() {
        return this.refWarehouseId;
    }

    public void setRefWarehouseCode(String refWarehouseCode) {
        this.refWarehouseCode = refWarehouseCode;
    }

    public String getRefWarehouseCode() {
        return this.refWarehouseCode;
    }

    public void setRefWarehouseName(String refWarehouseName) {
        this.refWarehouseName = refWarehouseName;
    }

    public String getRefWarehouseName() {
        return this.refWarehouseName;
    }

    public void setRefWarehouseType(Integer refWarehouseType) {
        this.refWarehouseType = refWarehouseType;
    }

    public Integer getRefWarehouseType() {
        return this.refWarehouseType;
    }

    public void setRefWarehouseSubType(Integer refWarehouseSubType) {
        this.refWarehouseSubType = refWarehouseSubType;
    }

    public Integer getRefWarehouseSubType() {
        return this.refWarehouseSubType;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setProportion(BigDecimal proportion) {
        this.proportion = proportion;
    }

    public BigDecimal getProportion() {
        return this.proportion;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public List<RefWarehouseRespDto> getRefWarehouseReqDtos() {
        return refWarehouseReqDtos;
    }

    public void setRefWarehouseReqDtos(List<RefWarehouseRespDto> refWarehouseReqDtos) {
        this.refWarehouseReqDtos = refWarehouseReqDtos;
    }
}