package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author: liuji
 * @Date: 2020-07-20 16:15
 * @since 2.0.0
 */
@ApiModel(value = "StorageAdjustRespDto", description = "库存调整返回dto")
public class StorageAdjustRespDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    @ApiModelProperty(name = "storageAdjustNo", value = "单据编号")
    private String storageAdjustNo;

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "仓库名")
    private String warehouseName;

    @ApiModelProperty(name = "positionId", value = "仓位ID")
    private Long positionId;

    @ApiModelProperty(name = "status", value = "单据状态(WAIT_COMMIT:待提交、WAIT_AUDIT:待审核、AUDIT_PASS：审核通过、AUDIT_NO_PASS:审核不通过、SUCCESS:执行成功、FAIL:执行失败)")
    private String status;

    @ApiModelProperty(name = "adjustType", value = "调整类型(COMMON_ADJUST:普通调整、SYSTEM_ADJUST:系统调整)")
    private String adjustType;

    @ApiModelProperty(name = "adjustMethod", value = "调整方式(COVER:覆盖、CUMULATIVE：累加)")
    private String adjustMethod;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    @ApiModelProperty(name = "direction", value = "数据方向", allowEmptyValue = true)
    private String direction;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStorageAdjustNo() {
        return storageAdjustNo;
    }

    public void setStorageAdjustNo(String storageAdjustNo) {
        this.storageAdjustNo = storageAdjustNo;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAdjustType() {
        return adjustType;
    }

    public void setAdjustType(String adjustType) {
        this.adjustType = adjustType;
    }

    public String getAdjustMethod() {
        return adjustMethod;
    }

    public void setAdjustMethod(String adjustMethod) {
        this.adjustMethod = adjustMethod;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }
}
