/*
 * @(#)StorageOrderCombineRespDto.java 1.0 2018-09-10
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 出入库查询响应组合Dto
 * 组合Dto中包含了出入库单dto、出入库单明细Dto。
 *
 * @author 书生
 * @since 2.0.0
 */
@ApiModel(value = "StorageOrderCombineRespDto", description = "出入库查询响应组合Dto，组合Dto中包含了出入库单dto、出入库单明细Dto。")
public class StorageOrderCombineRespDto extends BaseVo {

    /**
     * 出入库单Dto
     */
    @ApiModelProperty(name = "出入库单Dto", value = "出入库单Dto")
    private StorageOrderRespDto storageOrderRespDto;

    /**
     * 库存关联地址Dto对象
     */
    @ApiModelProperty(name = "库存关联地址Dto对象", value = "库存关联地址Dto对象")
    private AddressRespDto addressRespDto;

    /**
     * 出入库单明细Dto列表
     */
    @ApiModelProperty(name = "出入库单明细Dto列表", value = "出入库单明细Dto列表")
    private List<StorageOrderDetailRespDto> detailRespDtoList;

    public StorageOrderRespDto getStorageOrderRespDto() {
        return storageOrderRespDto;
    }

    public void setStorageOrderRespDto(StorageOrderRespDto storageOrderRespDto) {
        this.storageOrderRespDto = storageOrderRespDto;
    }

    public List<StorageOrderDetailRespDto> getDetailRespDtoList() {
        return detailRespDtoList;
    }

    public void setDetailRespDtoList(List<StorageOrderDetailRespDto> detailRespDtoList) {
        this.detailRespDtoList = detailRespDtoList;
    }

    public AddressRespDto getAddressRespDto() {
        return addressRespDto;
    }

    public void setAddressRespDto(AddressRespDto addressRespDto) {
        this.addressRespDto = addressRespDto;
    }
}
