/*
 * @(#)StorageOrderDetailRespDto.java 1.0 2018-09-10
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 出入库单明细查询响应Dto
 *
 * @author 书生
 * @since 2.0.0
 */
@ApiModel(value = "StorageOrderDetailRespDto", description = "出入库单明细查询响应Dto")
public class StorageOrderDetailRespDto extends BaseVo {
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;

    /**
     * 货品条码
     */
    @ApiModelProperty(name = "barCode", value = "货品条码")
    private String barCode;

    /**
     * 所属客户编码
     */
    @ApiModelProperty(name = "customerNo", value = "所属客户编码")
    private String customerNo;

    /**
     * 所属客户名称
     */
    @ApiModelProperty(name = "customerName", value = "所属客户名称")
    private String customerName;

    /**
     * 单据ID
     */
    @ApiModelProperty(name = "orderId", value = "单据ID")
    private Long orderId;

    /**
     * 单据编号
     */
    @ApiModelProperty(name = "orderNo", value = "单据编号")
    private String orderNo;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "positionId", value = "仓位ID")
    private Long positionId;

    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;

    /**
     * 货品数量
     */
    @ApiModelProperty(name = "num", value = "货品数量")
    private Long num;

    /**
     * 实际货品数量
     */
    @ApiModelProperty(name = "actualNum", value = "实际货品数量")
    private Long actualNum = 0L;

    /**
     * UNVERIFIED未核实 VERIFIED已核实 ABNORMAL异常
     */
    @ApiModelProperty(name = "status", value = "UNVERIFIED未核实 VERIFIED已核实 ABNORMAL异常")
    private String status;

    /**
     * extension
     */
    @ApiModelProperty(name = "extension", value = "扩展信息")
    private String extension;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getActualNum() {
        return actualNum;
    }

    public void setActualNum(Long actualNum) {
        this.actualNum = actualNum;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
