package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 仓库货品响应dto
 *
 * @author: fuyun
 * @Date: 2020/7/20 14:16
 */
@ApiModel(value = "WarehouseCargoRespDto", description = "仓库货品响应dto")
public class WarehouseCargoRespDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "仓库货品关联id")
    private Long id;

    @ApiModelProperty(name = "cargoId", value = "货品id")
    private Long cargoId;

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;

    @ApiModelProperty(name = "barCode", value = "货品条码")
    private String barCode;

    @ApiModelProperty(name = "customerNo", value = "所属客户编号")
    private String customerNo;

    @ApiModelProperty(name = "customerName", value = "所属客户")
    private String customerName;

    @ApiModelProperty(name = "inventoryShareStatus", value = "库存共享状态： 0 不开启 ，1 开启")
    private Integer inventoryShareStatus;

    @ApiModelProperty(name = "warningInventoryStatus", value = "库存预警状态： 1：库存紧张 ，2：库存较足，3：库存充足，4：售罄 ")
    private Integer warningInventoryStatus;

    @ApiModelProperty(name = "warningInventoryName", value = "库存预警状态名称 ")
    private String warningInventoryName;

    @ApiModelProperty(name = "warningInventoryX", value = "库存预警计算结果")
    private BigDecimal warningInventoryX;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    /**
     * 库存总数
     */
    @ApiModelProperty(name = "balance", value = " 库存总数  ", allowEmptyValue = true)
    private BigDecimal balance;
    /**
     * 预留
     */
    @ApiModelProperty(name = "reserved", value = " 预留  ", allowEmptyValue = true)
    private BigDecimal reserved;

    /**
     * 预占
     */
    @ApiModelProperty(name = "preempt", value = " 预占  ", allowEmptyValue = true)
    private BigDecimal preempt;

    /**
     * 可用
     */
    @ApiModelProperty(name = "available", value = " 可用  ", allowEmptyValue = true)
    private BigDecimal available;

    /**
     * 在途
     */
    @ApiModelProperty(name = "intransit", value = " 在途  ", allowEmptyValue = true)
    private BigDecimal intransit;

    /**
     * 期货库存
     */
    @ApiModelProperty(name = "futuresInventory", value = " 期货库存  ", allowEmptyValue = true)
    private BigDecimal futuresInventory;

    /**
     * 期货已发
     */
    @ApiModelProperty(name = "futuresIssued", value = " 期货已发  ", allowEmptyValue = true)
    private BigDecimal futuresIssued;

    /**
     * 待收
     */
    @ApiModelProperty(name = "pending", value = " 待收  ", allowEmptyValue = true)
    private BigDecimal pending;

    /**
     * GENERAL总仓 SEPERATE分仓 WHOLE全局仓库 STORE门店仓库
     */
    @ApiModelProperty(name = "warehouseType", value = " GENERAL总仓 SEPERATE分仓 WHOLE全局仓库 STORE门店仓库  ", allowEmptyValue = true)
    private String warehouseType;

    /**
     * 子类型： 0 其他仓，1电商仓，2第三方小程序仓，3自有小程序仓
     */
    @ApiModelProperty(name = "warehouseSubType", value = " 子类型： 0 其他仓，1电商仓，2第三方小程序仓，3自有小程序仓  ", allowEmptyValue = true)
    private Integer warehouseSubType;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Integer getInventoryShareStatus() {
        return inventoryShareStatus;
    }

    public void setInventoryShareStatus(Integer inventoryShareStatus) {
        this.inventoryShareStatus = inventoryShareStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getFuturesInventory() {
        return futuresInventory;
    }

    public void setFuturesInventory(BigDecimal futuresInventory) {
        this.futuresInventory = futuresInventory;
    }

    public BigDecimal getFuturesIssued() {
        return futuresIssued;
    }

    public void setFuturesIssued(BigDecimal futuresIssued) {
        this.futuresIssued = futuresIssued;
    }

    public BigDecimal getPending() {
        return pending;
    }

    public void setPending(BigDecimal pending) {
        this.pending = pending;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Integer getWarehouseSubType() {
        return warehouseSubType;
    }

    public void setWarehouseSubType(Integer warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public BigDecimal getReserved() {
        return reserved;
    }

    public void setReserved(BigDecimal reserved) {
        this.reserved = reserved;
    }

    public Integer getWarningInventoryStatus() {
        return warningInventoryStatus;
    }

    public void setWarningInventoryStatus(Integer warningInventoryStatus) {
        this.warningInventoryStatus = warningInventoryStatus;
    }

    public BigDecimal getWarningInventoryX() {
        return warningInventoryX;
    }

    public void setWarningInventoryX(BigDecimal warningInventoryX) {
        this.warningInventoryX = warningInventoryX;
    }

    public String getWarningInventoryName() {
        return warningInventoryName;
    }

    public void setWarningInventoryName(String warningInventoryName) {
        this.warningInventoryName = warningInventoryName;
    }
}
