/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseDeliveryDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 仓库响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "WarehouseRespDto", description = "仓库响应Dto")
public class WarehouseRespDto extends ResponseDto {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "id", value = "仓库ID")
    private Long id;

    /**
     * 父级物理仓Id（逻辑仓对应的父级物理仓）
     */
    @ApiModelProperty(name = "parentId", value = "父级物理仓Id（逻辑仓对应的父级物理仓）")
    private Long parentId;

    /**
     * 所属渠道,逗号隔开
     */
    @ApiModelProperty(name = "channelIds", value = "所属渠道,逗号隔开")
    private String channelIds;

    /**
     * 业务形态：0 零售，1 大货，2 全部
     */
    @ApiModelProperty(name = "businessForm", value = "业务形态：0 零售，1 大货，2 全部")
    private Integer businessForm;

    /**
     * 是否主仓：0否1是
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "code", value = "仓库编码")
    private String code;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "name", value = "仓库名称")
    private String name;


    @ApiModelProperty(name = "type", value = "0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓")
    private String type;

    @ApiModelProperty(name = "subType", value = "仓库子类型: 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓（实际库存）\n" +
            "    逻辑仓：4 电商仓、5 经销商仓、6 门店仓（出入库）\n" +
            "    共享仓：7 平台电商共享仓、8 自营电商仓\n" +
            "    渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS")
    private Integer subType;

    /**
     * 仓库状态
     */
    @ApiModelProperty(name = "status", value = "NORMAL正常 BANNED封禁 CORRECTION整改")
    private String status;

    /**
     * 库存共享状态
     */
    @ApiModelProperty(name = "inventoryShareStatus", value = "库存共享状态：0 不开启(默认), 1 开启")
    private Integer inventoryShareStatus;

    /**
     * 库存共享类型：0单组织，1全局
     */
    @ApiModelProperty(name = "inventoryShareType", value = "库存共享类型：0单组织，1全局")
    private Integer inventoryShareType;

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码")
    private String provCode;

    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码")
    private String areaCode;

    /**
     * 详细地址
     */
    @ApiModelProperty(name = "addr", value = "详细地址")
    private String addr;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;

    /**
     * 路由状态：NORMAL 正常、BANNED 禁用
     */
    private String routeStatus;

    /**
     * 品牌范围
     */
    @ApiModelProperty(name = "brandCode", value = "品牌code", required = true)
    private String brandCode;


    @ApiModelProperty(name = "brandName", value = "品牌名称", required = true)
    private String brandName;

    /**
     * 仓库地址的经纬度坐标
     */
    @ApiModelProperty(name = "coordinates", value = "仓库地址的经纬度坐标", required = true)
    private String coordinates;

    @ApiModelProperty(name = "longitude", value = "仓库坐标经度")
    private BigDecimal longitude;

    @ApiModelProperty(name = "latitude", value = "仓库坐标纬度")
    private BigDecimal latitude;

    @ApiModelProperty(name = "distance", value = "与当前坐标距离")
    private Long distance;

    /**
     * 备注信息
     */
    @ApiModelProperty(name = "remark", value = "备注信息")
    private String remark;

    /**
     * 所属组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "所属组织ID")
    private Long organizationId;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    /**
     * 所属组织id集合，用于树状回显
     */
    @ApiModelProperty(name = "organizationIds", value = "所属组织Id集合")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "contactPerson", value = "负责人名字")
    private String contactPerson;

    /**
     * 联系方式
     */
    @ApiModelProperty(name = "contactPhone", value = "联系方式")
    private String contactPhone;

    /**
     * 发货阈值
     */
    @ApiModelProperty(name = "deliverThresholdValue", value = "发货阈值")
    private Integer deliverThresholdValue;

    /**
     * 信用分
     */
    @ApiModelProperty(name = "creditValue", value = "信用分")
    private Integer creditValue;

    /**
     * 发货时效
     */
    @ApiModelProperty(name = "deliverTimeLimit", value = "发货时效")
    private Integer deliverTimeLimit;

    /**
     * 快递配送启用状态： 1 启用 0 不启用
     */
    @ApiModelProperty(name = "expressDeliveryStatus", value = " 快递启用状态： 1 启用 0 不启用")
    private Integer expressDeliveryStatus;

    /**
     * 快递配送区域
     */
    @ApiModelProperty(name = "serviceAreaList", value = "快递配送区域")
    private List<AreaDto> serviceAreaList;

    /**
     * 同城配送启用状态：1 启用 0 不启用
     */
    @ApiModelProperty(name = "cityDeliveryStatus", value = " 同城配送启用状态：1 启用 0 不启用")
    private Integer cityDeliveryStatus;


    /**
     * 配送方类型： 1 商家配送 2 第三方配送
     */
    @ApiModelProperty(name = "deliveryPartyType", value = " 配送方类型： 1 商家配送 2 第三方配送")
    private Integer deliveryPartyType;

    @ApiModelProperty(name = "warehouseDeliveryDtoList", value = "仓库配送方信息")
    private List<WarehouseDeliveryDto> warehouseDeliveryDtoList;

    /**
     * 地理围栏信息
     */
    @ApiModelProperty(name = "geoFence", value = "地理围栏信息")
    private String geoFence;


    @ApiModelProperty(name = "updateTime", value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(name = "continueRejectOrder", value = "连续拒单次数")
    private Integer continueRejectOrder;

    @ApiModelProperty(name = "continueRejectOrder", value = "连续接单次数")
    private Integer continueReceiveOrder;

    @ApiModelProperty(name = "deliveryCount", value = "发货总次数")
    private int deliveryCount;

    @ApiModelProperty(name = "deliveryTimeTotal", value = "发货总时长")
    private long deliveryTimeTotal;

    @ApiModelProperty(name = "deliveryTimeAvg", value = "发货平均时长")
    private double deliveryTimeAvg;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getInventoryShareStatus() {
        return inventoryShareStatus;
    }

    public void setInventoryShareStatus(Integer inventoryShareStatus) {
        this.inventoryShareStatus = inventoryShareStatus;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getProvCode() {
        return this.provCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getAddr() {
        return this.addr;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(String routeStatus) {
        this.routeStatus = routeStatus;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public Integer getDeliverThresholdValue() {
        return deliverThresholdValue;
    }

    public void setDeliverThresholdValue(Integer deliverThresholdValue) {
        this.deliverThresholdValue = deliverThresholdValue;
    }

    public Integer getCreditValue() {
        return creditValue;
    }

    public void setCreditValue(Integer creditValue) {
        this.creditValue = creditValue;
    }

    public Integer getDeliverTimeLimit() {
        return deliverTimeLimit;
    }

    public void setDeliverTimeLimit(Integer deliverTimeLimit) {
        this.deliverTimeLimit = deliverTimeLimit;
    }

    public String getGeoFence() {
        return geoFence;
    }

    public void setGeoFence(String geoFence) {
        this.geoFence = geoFence;
    }

    public List<AreaDto> getServiceAreaList() {
        return serviceAreaList;
    }

    public void setServiceAreaList(List<AreaDto> serviceAreaList) {
        this.serviceAreaList = serviceAreaList;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public Long getDistance() {
        return distance;
    }

    public void setDistance(Long distance) {
        this.distance = distance;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public Integer getExpressDeliveryStatus() {
        return expressDeliveryStatus;
    }

    public void setExpressDeliveryStatus(Integer expressDeliveryStatus) {
        this.expressDeliveryStatus = expressDeliveryStatus;
    }

    public Integer getCityDeliveryStatus() {
        return cityDeliveryStatus;
    }

    public void setCityDeliveryStatus(Integer cityDeliveryStatus) {
        this.cityDeliveryStatus = cityDeliveryStatus;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getDeliveryPartyType() {
        return deliveryPartyType;
    }

    public void setDeliveryPartyType(Integer deliveryPartyType) {
        this.deliveryPartyType = deliveryPartyType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public Integer getContinueRejectOrder() {
        return continueRejectOrder;
    }

    public void setContinueRejectOrder(Integer continueRejectOrder) {
        this.continueRejectOrder = continueRejectOrder;
    }

    public Integer getContinueReceiveOrder() {
        return continueReceiveOrder;
    }

    public void setContinueReceiveOrder(Integer continueReceiveOrder) {
        this.continueReceiveOrder = continueReceiveOrder;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public int getDeliveryCount() {
        return deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public long getDeliveryTimeTotal() {
        return deliveryTimeTotal;
    }

    public void setDeliveryTimeTotal(long deliveryTimeTotal) {
        this.deliveryTimeTotal = deliveryTimeTotal;
    }

    public double getDeliveryTimeAvg() {
        return deliveryTimeAvg;
    }

    public void setDeliveryTimeAvg(double deliveryTimeAvg) {
        this.deliveryTimeAvg = deliveryTimeAvg;
    }

    public String getChannelIds() {
        return channelIds;
    }

    public void setChannelIds(String channelIds) {
        this.channelIds = channelIds;
    }

    public List<WarehouseDeliveryDto> getWarehouseDeliveryDtoList() {
        return warehouseDeliveryDtoList;
    }

    public void setWarehouseDeliveryDtoList(List<WarehouseDeliveryDto> warehouseDeliveryDtoList) {
        this.warehouseDeliveryDtoList = warehouseDeliveryDtoList;
    }

    public Integer getInventoryShareType() {
        return inventoryShareType;
    }

    public void setInventoryShareType(Integer inventoryShareType) {
        this.inventoryShareType = inventoryShareType;
    }

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }
}