package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.ResponseDto;

import java.math.BigDecimal;

/**
 * 发货单路由仓库路由信息
 *
 * @author 浮云
 */
public class WarehouseRouteRestDto extends ResponseDto {

    /**
     * 仓库id
     */
    protected Long id;

    /**
     * 仓库编码
     */
    private String code;
    /**
     * 仓库名字
     */
    private String name;

    /**
     * 仓库类型
     */
    private String type;

    /**
     * 仓库子类型
     */
    private Integer subType;

    /**
     * 状态
     */
    private String status;

    /**
     * 路由状态
     */
    private String routeStatus;

    /**
     * 库存共享状态： 0 不开启,1 开启
     */
    private Boolean inventoryShareStatus;

    /**
     * 仓库地址经度
     */
    private BigDecimal longitude;

    /**
     * 仓库地址纬度
     */
    private BigDecimal latitude;

    /**
     * 所属组织code
     */
    private Long organizationId;

    /**
     * 所属组织名称
     */
    private String organizationName;

    /**
     * 发货阈值
     */
    private Integer deliverThresholdValue;

    /**
     * 剩余发货阈值
     */
    private Integer deliverThresholdLeftValue;

    /**
     * 阈值分
     */
    private Integer thresholdValue;

    /**
     * 信用分
     */
    private Integer creditValue;

    /**
     * 发货时效
     */
    private Integer deliverTimeLimit;

    /**
     * 快递启用状态： 1 启用 0 不启用
     */
    private Boolean expressDeliveryStatus;

    /**
     * 与当前经纬度的距离
     */
    private double distance;

    /**
     * 信用分
     */
    private double creditScore;

    /**
     * 发货阈值分
     */
    private double thresholdScore;

    /**
     * 库存分
     */
    private double inventoryScore;

    /**
     * 发货效率分
     */
    private double deliverTimeScore;

    /**
     * 距离分
     */
    private double distanceScore;

    /**
     * 是否丢弃，true-丢弃，false-不丢弃，
     * 1、库存满足，得分100，不满足整体得分为0，为丢弃状态。
     * 2、发货阈值为0时，整体得分为0，为丢弃状态。
     */
    private boolean discard = false;

    /**
     * 路由总得分
     */
    private double totalScore;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(String routeStatus) {
        this.routeStatus = routeStatus;
    }

    public Boolean getInventoryShareStatus() {
        return inventoryShareStatus;
    }

    public void setInventoryShareStatus(Boolean inventoryShareStatus) {
        this.inventoryShareStatus = inventoryShareStatus;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getDeliverThresholdValue() {
        return deliverThresholdValue;
    }

    public void setDeliverThresholdValue(Integer deliverThresholdValue) {
        this.deliverThresholdValue = deliverThresholdValue;
    }

    public Integer getCreditValue() {
        return creditValue;
    }

    public void setCreditValue(Integer creditValue) {
        this.creditValue = creditValue;
    }

    public Integer getDeliverTimeLimit() {
        return deliverTimeLimit;
    }

    public void setDeliverTimeLimit(Integer deliverTimeLimit) {
        this.deliverTimeLimit = deliverTimeLimit;
    }

    public Boolean getExpressDeliveryStatus() {
        return expressDeliveryStatus;
    }

    public void setExpressDeliveryStatus(Boolean expressDeliveryStatus) {
        this.expressDeliveryStatus = expressDeliveryStatus;
    }

    public double getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(double totalScore) {
        this.totalScore = totalScore;
    }

    public double getDistance() {
        return distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public Integer getDeliverThresholdLeftValue() {
        return deliverThresholdLeftValue;
    }

    public void setDeliverThresholdLeftValue(Integer deliverThresholdLeftValue) {
        this.deliverThresholdLeftValue = deliverThresholdLeftValue;
    }

    public double getCreditScore() {
        return creditScore;
    }

    public void setCreditScore(double creditScore) {
        this.creditScore = creditScore;
    }

    public double getThresholdScore() {
        return thresholdScore;
    }

    public void setThresholdScore(double thresholdScore) {
        this.thresholdScore = thresholdScore;
    }

    public double getInventoryScore() {
        return inventoryScore;
    }

    public void setInventoryScore(double inventoryScore) {
        this.inventoryScore = inventoryScore;
    }

    public double getDeliverTimeScore() {
        return deliverTimeScore;
    }

    public void setDeliverTimeScore(double deliverTimeScore) {
        this.deliverTimeScore = deliverTimeScore;
    }

    public double getDistanceScore() {
        return distanceScore;
    }

    public void setDistanceScore(double distanceScore) {
        this.distanceScore = distanceScore;
    }

    public boolean isDiscard() {
        return discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public Integer getThresholdValue() {
        return thresholdValue;
    }

    public void setThresholdValue(Integer thresholdValue) {
        this.thresholdValue = thresholdValue;
    }
}