package com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.AddressRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * DiffOrderRespDto对象
 *
 * @author qiuzhi
 * @since 2021-05-24
 */
@ApiModel(value = "DiffOrderRespDto", description = "DiffOrder响应对象")
public class DiffOrderRespDto extends BaseRespDto {
    /**
     * 来源单号(调拨入库单)
     */
    @ApiModelProperty(value = "来源单号(调拨入库单)")
    private Long orderSrcId;
    /**
     * 单据来源
     */
    @ApiModelProperty(value = "单据来源")
    private String orderSrc;

    /**
     * 发货物理仓ID
     */
    @ApiModelProperty(value = "发货物理仓ID")
    private Long outPhysicalWarehouseId;

    /**
     * 发货逻辑仓ID
     */
    @ApiModelProperty(value = "发货逻辑仓ID")
    private Long outLogicWarehouseId;

    /**
     * 收货物理仓ID
     */
    @ApiModelProperty(value = "收货物理仓ID")
    private Long inPhysicalWarehouseId;
    /**
     * 收货逻辑仓ID
     */
    @ApiModelProperty(value = "收货逻辑仓ID")
    private Long inLogicWarehouseId;

    /**
     * 发货物理仓
     */
    @ApiModelProperty(value = "发货物理仓")
    private String outPhysicalWarehouseName;

    /**
     * 发货逻辑仓
     */
    @ApiModelProperty(value = "发货逻辑仓")
    private String outLogicWarehouseName;

    /**
     * 收货物理仓
     */
    @ApiModelProperty(value = "收货物理仓")
    private String inPhysicalWarehouseName;
    /**
     * 收货逻辑仓
     */
    @ApiModelProperty(value = "收货逻辑仓")
    private String inLogicWarehouseName;

    @ApiModelProperty(value = "计划数量")
    private Integer orderNum;

    @ApiModelProperty(value = "实际数量")
    private Integer resultNum;

    /**
     * 出库单ID
     */
    @ApiModelProperty(value = "出库单ID")
    private Long outStorageId;

    /**
     * 入库单ID
     */
    @ApiModelProperty(value = "入库单ID")
    private Long inStorageId;


    @ApiModelProperty(value = "收件信息")
    private AddressRespDto addressRespDto;

    public Long getOrderSrcId() {
        return orderSrcId;
    }

    public void setOrderSrcId(Long orderSrcId) {
        this.orderSrcId = orderSrcId;
    }

    public String getOrderSrc() {
        return orderSrc;
    }

    public void setOrderSrc(String orderSrc) {
        this.orderSrc = orderSrc;
    }

    public Long getOutPhysicalWarehouseId() {
        return outPhysicalWarehouseId;
    }

    public void setOutPhysicalWarehouseId(Long outPhysicalWarehouseId) {
        this.outPhysicalWarehouseId = outPhysicalWarehouseId;
    }

    public Long getOutLogicWarehouseId() {
        return outLogicWarehouseId;
    }

    public void setOutLogicWarehouseId(Long outLogicWarehouseId) {
        this.outLogicWarehouseId = outLogicWarehouseId;
    }

    public Long getInPhysicalWarehouseId() {
        return inPhysicalWarehouseId;
    }

    public void setInPhysicalWarehouseId(Long inPhysicalWarehouseId) {
        this.inPhysicalWarehouseId = inPhysicalWarehouseId;
    }

    public Long getInLogicWarehouseId() {
        return inLogicWarehouseId;
    }

    public void setInLogicWarehouseId(Long inLogicWarehouseId) {
        this.inLogicWarehouseId = inLogicWarehouseId;
    }

    public String getOutPhysicalWarehouseName() {
        return outPhysicalWarehouseName;
    }

    public void setOutPhysicalWarehouseName(String outPhysicalWarehouseName) {
        this.outPhysicalWarehouseName = outPhysicalWarehouseName;
    }

    public String getOutLogicWarehouseName() {
        return outLogicWarehouseName;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public String getInPhysicalWarehouseName() {
        return inPhysicalWarehouseName;
    }

    public void setInPhysicalWarehouseName(String inPhysicalWarehouseName) {
        this.inPhysicalWarehouseName = inPhysicalWarehouseName;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public Integer getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    public Integer getResultNum() {
        return resultNum;
    }

    public void setResultNum(Integer resultNum) {
        this.resultNum = resultNum;
    }

    public Long getOutStorageId() {
        return outStorageId;
    }

    public void setOutStorageId(Long outStorageId) {
        this.outStorageId = outStorageId;
    }

    public Long getInStorageId() {
        return inStorageId;
    }

    public void setInStorageId(Long inStorageId) {
        this.inStorageId = inStorageId;
    }

    public AddressRespDto getAddressRespDto() {
        return addressRespDto;
    }

    public void setAddressRespDto(AddressRespDto addressRespDto) {
        this.addressRespDto = addressRespDto;
    }
}
