package com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * TransferOrderDetailRespDto对象
 *
 * @author qiuzhi
 * @since 2021-05-22
 */
@ApiModel(value = "TransferOrderDetailRespDto", description = "TransferOrderDetail响应对象")
public class TransferOrderDetailRespDto extends BaseRespDto {

    /**
     * 调拨单ID
     */
    @ApiModelProperty(value = "调拨单ID")
    private Long orderId;
    /**
     * 货品ID
     */
    @ApiModelProperty(value = "货品ID")
    private Long cargoId;

    /**
     * 可用库存
     */
    @ApiModelProperty(value = "可用库存")
    private BigDecimal available;

    /**
     * 计划数量
     */
    @ApiModelProperty(value = "计划数量")
    private BigDecimal num;

    /**
     * 实际入库数量
     */
    @ApiModelProperty(value = "实际入库数量")
    private Integer resultNum;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(value = "货品名称")
    private String cargoName;

    @ApiModelProperty(value = "货品货号")
    private String cargoArtNo;

    @ApiModelProperty(value = "货品条码")
    private String cargoBarCode;

    @ApiModelProperty(value = "货品所属客户编码")
    private String cargoCustomerNo;

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }


    public Integer getResultNum() {
        return resultNum;
    }

    public void setResultNum(Integer resultNum) {
        this.resultNum = resultNum;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoArtNo() {
        return cargoArtNo;
    }

    public void setCargoArtNo(String cargoArtNo) {
        this.cargoArtNo = cargoArtNo;
    }

    public String getCargoBarCode() {
        return cargoBarCode;
    }

    public void setCargoBarCode(String cargoBarCode) {
        this.cargoBarCode = cargoBarCode;
    }

    public String getCargoCustomerNo() {
        return cargoCustomerNo;
    }

    public void setCargoCustomerNo(String cargoCustomerNo) {
        this.cargoCustomerNo = cargoCustomerNo;
    }
}
