package com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.AddressRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * TransferOrderRespDto对象
 *
 * @author qiuzhi
 * @since 2021-05-21
 */
@ApiModel(value = "TransferOrderRespDto", description = "TransferOrder响应对象")
public class TransferOrderRespDto extends BaseRespDto {

    /**
     * 业务单号
     */
    @ApiModelProperty(value = "业务单号")
    private String orderNo;

    /**
     * 来源单号
     */
    @ApiModelProperty(value = "来源单号")
    private String sourceCode;

    /**
     * 发货物理仓ID
     */
    @ApiModelProperty(value = "发货物理仓ID")
    private Long outPhysicalWarehouseId;

    /**
     * 收货物理仓ID
     */
    @ApiModelProperty(value = "收货物理仓ID")
    private Long inPhysicalWarehouseId;

    /**
     * 发货逻辑仓ID
     */
    @ApiModelProperty(value = "发货逻辑仓ID")
    private Long outLogicWarehouseId;

    /**
     * 收货逻辑仓ID
     */
    @ApiModelProperty(value = "收货逻辑仓ID")
    private Long inLogicWarehouseId;

    /**
     * 出库单ID
     */
    @ApiModelProperty(value = "出库单ID")
    private Long outStorageId;

    /**
     * 入库单ID
     */
    @ApiModelProperty(value = "入库单ID")
    private Long inStorageId;

    /**
     * 待提交、待审核、待执行、执行中、已完成、已取消
     */
    @ApiModelProperty(value = "待提交、待审核、待执行、执行中、已完成、已取消")
    private Integer status;

    /**
     * 物理仓调拨、虚拟仓调拨
     */
    @ApiModelProperty(value = "物理仓调拨、虚拟仓调拨")
    private Integer type;

    /**
     * 审核说明
     */
    @ApiModelProperty(value = "审核说明")
    private String auditDesc;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "货品列表")
    private List<TransferOrderDetailRespDto> transferOrderDetails;

    /**
     * 收发差异单ID
     */
    @ApiModelProperty(value = "收发差异单ID")
    private Long diffOrderId;

    /**
     * 审核时间
     */
    @ApiModelProperty(name = "审核时间")
    private Date auditTime;

    /**
     * 审核人
     */
    @ApiModelProperty(name = "审核人")
    private String auditPerson;

    @ApiModelProperty(value = "出库单状态")
    private String outStatus;

    @ApiModelProperty(value = "入库单状态")
    private String inStatus;

    @ApiModelProperty(value = "收货人地址")
    private AddressRespDto addressRespDto;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public Long getOutPhysicalWarehouseId() {
        return outPhysicalWarehouseId;
    }

    public void setOutPhysicalWarehouseId(Long outPhysicalWarehouseId) {
        this.outPhysicalWarehouseId = outPhysicalWarehouseId;
    }

    public Long getInPhysicalWarehouseId() {
        return inPhysicalWarehouseId;
    }

    public void setInPhysicalWarehouseId(Long inPhysicalWarehouseId) {
        this.inPhysicalWarehouseId = inPhysicalWarehouseId;
    }

    public Long getOutLogicWarehouseId() {
        return outLogicWarehouseId;
    }

    public void setOutLogicWarehouseId(Long outLogicWarehouseId) {
        this.outLogicWarehouseId = outLogicWarehouseId;
    }

    public Long getInLogicWarehouseId() {
        return inLogicWarehouseId;
    }

    public void setInLogicWarehouseId(Long inLogicWarehouseId) {
        this.inLogicWarehouseId = inLogicWarehouseId;
    }

    public Long getOutStorageId() {
        return outStorageId;
    }

    public void setOutStorageId(Long outStorageId) {
        this.outStorageId = outStorageId;
    }

    public Long getInStorageId() {
        return inStorageId;
    }

    public void setInStorageId(Long inStorageId) {
        this.inStorageId = inStorageId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<TransferOrderDetailRespDto> getTransferOrderDetails() {
        return transferOrderDetails;
    }

    public void setTransferOrderDetails(List<TransferOrderDetailRespDto> transferOrderDetails) {
        this.transferOrderDetails = transferOrderDetails;
    }

    public Long getDiffOrderId() {
        return diffOrderId;
    }

    public void setDiffOrderId(Long diffOrderId) {
        this.diffOrderId = diffOrderId;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getOutStatus() {
        return outStatus;
    }

    public void setOutStatus(String outStatus) {
        this.outStatus = outStatus;
    }

    public String getInStatus() {
        return inStatus;
    }

    public void setInStatus(String inStatus) {
        this.inStatus = inStatus;
    }

    public AddressRespDto getAddressRespDto() {
        return addressRespDto;
    }

    public void setAddressRespDto(AddressRespDto addressRespDto) {
        this.addressRespDto = addressRespDto;
    }
}
