package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 路由错误码
 */
public enum DeliveryErrorEnum {

    /**
     * 路由错误码
     */
    ERROR_100000("100000", "系统异常", "TO_DO"),
    ERROR_610000("610000", "找不到渠道对应渠道的路由规则", "TO_DO"),
    ERROR_610001("610001", "指定路由，仓库找不到对应的货品信息", "TO_ASSIGN"),
    ERROR_610002("610002", "指定路由，仓库货品可用库存不足", "TO_ASSIGN"),
    ERROR_610003("610003", "库存规则未配置路由类型", "TO_ASSIGN"),
    ERROR_610004("610004", "发货单无渠道信息", "TO_ASSIGN"),
    ERROR_610005("610005", "找不到发货单对应的商品信息", "TO_ASSIGN"),
    ERROR_610006("610006", "指定路径未配置具体的仓库编号", "TO_ASSIGN"),
    ERROR_610007("610007", "指定路径仓库找不到对应的仓库信息", "TO_ASSIGN"),
    ERROR_610009("610009", "发货单货品没有对应的货品编码", "TO_ASSIGN"),
    ERROR_610010("610010", "匹配不到满足条件的仓库", "TO_ASSIGN"),
    ERROR_610011("610011", "匹配不到满足条件的仓库货品", "TO_ASSIGN"),
    ERROR_610012("610012", "匹配不到不需要拆单满足路由的仓库", "TO_ASSIGN"),
    ERROR_610013("610013", "门店设置未配置距离设置", "TO_ASSIGN"),
    ERROR_610014("610014", "路由规则权重为空", "TO_ASSIGN"),
    ERROR_610015("610015", "未配置高德地图URL和KEY", "TO_ASSIGN"),
    ERROR_610016("610016", "高德地图查询不到地址对应的经纬度", "TO_DO"),
    ERROR_610017("610017", "库存规则未配置路由类型", "TO_ASSIGN"),
    ERROR_610018("610018", "根据仓库ID集合查询仓库出现异常", "TO_ASSIGN"),
    ERROR_610019("610019", "发货单不为待路由状态", "TO_ASSIGN"),
    ERROR_610020("610020", "仓库货品可用库存总数不足", "TO_ASSIGN"),
    ERROR_610021("610021", "路由规则未设置是否需要拆单", "TO_DO"),
    ERROR_610022("610022", "发货单路由成功", "TO_RECEIVING/INIT"),
    ERROR_610023("610023", "发货拆单成功", "CANCELED"),
    ERROR_610024("610024", "发货拆单生成子发货单成功", "CANCELED"),
    ;

    public static DeliveryErrorEnum getByCode(String code) {
        for (DeliveryErrorEnum deliveryErrorEnum : DeliveryErrorEnum.values()) {
            if (deliveryErrorEnum.getErrorCode().equals(code)) {
                return deliveryErrorEnum;
            }
        }
        return null;
    }

    DeliveryErrorEnum(String errorCode, String desc, String toStatus) {
        this.errorCode = errorCode;
        this.desc = desc;
        this.toStatus = toStatus;
    }

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误描述
     */
    private String desc;

    /**
     * 状态改变为
     */
    private String toStatus;


    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getToStatus() {
        return toStatus;
    }

    public void setToStatus(String toStatus) {
        this.toStatus = toStatus;
    }
}
