package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 发货单路由操作枚举
 *
 * @author: fuyun
 * @Date: 2020/9/28 9:57
 */
public enum DeliveryRouteOptEnum {

    /**
     * 发货单路由操作枚举
     */
    GENERATE("GENERATE", "系统生成发货单"),
    AUTO_ROUTE("AUTO_ROUTE", "系统自动路由"),
    RE_ROUTE("RE_ROUTE", "重新路由"),
    RECEIVE_ORDER("RECEIVE_ORDER", "接单"),
    REJECT_ORDER("REJECT_ORDER", "拒单"),
    ASSIGN("ASSIGN", "指派"),
    DELIVER("DELIVER", "发货"),
    PARTIAL_DELIVERED("PARTIAL_DELIVERED", "部分发货"),
    UNABLE_DELIVER("UNABLE_DELIVER", "无法发货"),
    SIGNED("SIGNED", "签收"),
    CANCEL("CANCEL", "取消"),
    RECEIVE_TIMEOUT("RECEIVE_TIMEOUT", "超时未接单"),
    DELIVER_TIMEOUT("DELIVER_TIMEOUT", "超时未发货"),
    SYS_CANCEL("SYS_CANCEL", "系统取消"),
    CONFIRM("CONFIRM", "确认"),
    ;


    DeliveryRouteOptEnum(String optCode, String optDesc) {
        this.optCode = optCode;
        this.optDesc = optDesc;
    }

    /**
     * 根据操作编码查询描述
     *
     * @param optCode 操作编码
     * @return
     */
    public static String getDescByCode(String optCode) {
        for (DeliveryRouteOptEnum deliveryRouteOptEnum : DeliveryRouteOptEnum.values()) {
            if (deliveryRouteOptEnum.getOptCode().equals(optCode)) {
                return deliveryRouteOptEnum.getOptDesc();
            }
        }
        return null;
    }

    /**
     * 操作编码
     */
    private String optCode;

    /**
     * 操作描述
     */
    private String optDesc;

    public String getOptCode() {
        return optCode;
    }

    public void setOptCode(String optCode) {
        this.optCode = optCode;
    }

    public String getOptDesc() {
        return optDesc;
    }

    public void setOptDesc(String optDesc) {
        this.optDesc = optDesc;
    }
}
