package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 发货单路由规则枚举
 *
 * @author: fuyun
 * @Date: 2020/8/28 16:54
 */
public enum DeliveryRouteRuleEnum {
    /**
     * 权重类型，0-库存，1-距离，2-发货阈值，3-发货效率，4-发货信用
     */
    INVENTORY("0", "库存"),
    DISTANCE("1", "距离"),
    THRESHOLD("2", "发货阈值"),
    EFFICIENCY("3", "发货效率"),
    CREDIT_VALUE("4", "发货信用"),
    ;

    DeliveryRouteRuleEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
