package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 库存规则组内容操作符枚举
 *
 * @author: fuyun
 * @Date: 2020/9/12 16:21
 */
public enum DeliveryRuleOptEnum {

    /**
     * 库存规则组内容操作符枚举
     */
    EQ("=", "等于"),
    NE("!=", "不等于"),
    GT(">", "大于"),
    LT("<", "小于"),
    GE(">=", "大于等于"),
    LE("<=", "小于等于"),
    IN("in", "在列表中"),
    NOT_IN("not in", "不在列表中"),
    LIKE("like", "like"),
    NOT_LIKE("not_like", "not_like");

    private String opt;

    private String desc;

    DeliveryRuleOptEnum(String opt, String desc) {
        this.opt = opt;
        this.desc = desc;
    }

    public String getOpt() {
        return opt;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
