package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 库存规则组规则关系枚举
 *
 * @author: fuyun
 * @Date: 2020/9/12 16:21
 */
public enum DeliveryRuleRelationshipEnum {

    /**
     * 库存规则组规则关系枚举
     */
    ADD(0, "AND", "且"),
    OR(1, "OR", "或");

    DeliveryRuleRelationshipEnum(Integer ruleRelationship, String code, String desc) {
        this.ruleRelationship = ruleRelationship;
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据关系值获取对应枚举
     *
     * @param ruleRelationship 关系值
     * @return
     */
    public static DeliveryRuleRelationshipEnum getByRuleRelationship(Integer ruleRelationship) {
        for (DeliveryRuleRelationshipEnum deliveryRuleRelationshipEnum : DeliveryRuleRelationshipEnum.values()) {
            if (deliveryRuleRelationshipEnum.getRuleRelationship().equals(ruleRelationship)) {
                return deliveryRuleRelationshipEnum;
            }
        }
        return DeliveryRuleRelationshipEnum.ADD;
    }

    /**
     * 关系值
     */
    private Integer ruleRelationship;

    /**
     * 关系code
     */
    private String code;

    /**
     * 关系描述
     */
    private String desc;

    public Integer getRuleRelationship() {
        return ruleRelationship;
    }

    public void setRuleRelationship(Integer ruleRelationship) {
        this.ruleRelationship = ruleRelationship;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
