package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 发货单状态枚举
 *
 * @author 浮云
 */
public enum DeliveryStatusEnum {

    /**
     * 发货单状态枚举值，编码,描述
     * <p>
     * TO_ROUTE:待路由, TO_DO:待处理，TO_ASSIGN:待指派, TO_RECEIVING: 待接单, INIT: 待发货, PARTIAL_DELIVERED: 部分发货,
     * DELIVERED: 已发货, SIGNED: 已签收, CANCELED: 已取消, FINISHED: 已完成
     */
    TO_CONFIRM("TO_CONFIRM", "待确认"),
    TO_ROUTE("TO_ROUTE", "待路由"),
    TO_DO("TO_DO", "待处理"),
    TO_ASSIGN("TO_ASSIGN", "待指派"),
    TO_RECEIVING("TO_RECEIVING", "待接单"),
    INIT("INIT", "待发货"),
    FAIL("FAIL", "路由失败"),
    PARTIAL_DELIVERED("PARTIAL_DELIVERED", "部分发货"),
    DELIVERED("DELIVERED", "已发货"),
    SIGNED("SIGNED", "已签收"),
    PROCESSING("PROCESSING", "处理中"),
    CANCELED("CANCELED", "已取消"),
    FINISHED("FINISHED", "已完成");

    DeliveryStatusEnum(String status, String msg) {
        this.status = status;
        this.msg = msg;
    }

    /**
     * 根据状态获取名称描述
     *
     * @param status
     * @return
     */
    public static String getMsg(String status) {
        for (DeliveryStatusEnum deliveryOrderTypeEnum : DeliveryStatusEnum.values()) {
            if (deliveryOrderTypeEnum.status.equals(status)) {
                return deliveryOrderTypeEnum.getMsg();
            }
        }
        return null;
    }

    private String status;
    private String msg;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
