package com.dtyunxi.yundt.cube.center.inventory.api.enums;

/**
 * 库存优先级枚举
 *
 * @author: fuyun
 * @Date: 2020/9/12 18:14
 */
public enum InventoryPriorityEnum {
    /**
     * 库存优先级枚举
     */
    INVENTORY(0, "库存优先"),
    ROUTE_SCORE(1, "路由得分优先");

    /**
     * 优先级
     */
    private Integer priority;

    /**
     * 描述
     */
    private String desc;

    InventoryPriorityEnum(Integer priority, String desc) {
        this.priority = priority;
        this.desc = desc;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
