package com.dtyunxi.yundt.cube.center.inventory.api.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 仓库子类型
 */
public enum WarehouseSubTypeEnum {

    /*类型：物理仓、逻辑仓、共享仓、渠道仓
    物理仓：总仓、区域仓、第三方仓、门店仓（实际库存）
    逻辑仓：电商仓、经销商仓、门店仓（出入库）
    共享仓：平台电商共享仓、自营电商仓
    渠道仓：自营小程序仓、第三方小程序仓、OMS*/

    PHYSICAL_HEAD_WAREHOUSE(0, "总仓", 0),
    PHYSICAL_DISTRICT_WAREHOUSE(1, "区域仓", 0),
    PHYSICAL_THIRD_PARTY_WAREHOUSE(2, "第三方仓", 0),
    PHYSICAL_SHOP_WAREHOUSE(3, "门店仓(实际库存)", 0),
    LOGICAL_ECOMMERCE_WAREHOUSE(4, "电商仓", 1),
    LOGICAL_DEALER_WAREHOUSE(5, "经销商仓", 1),
    LOGICAL_SHOP_WAREHOUSE(6, "门店仓", 1),
    SHARE_PLATFORM_ECOMMERCE_WAREHOUSE(7, "平台电商共享仓", 2),
    SHARE_SELF_ECOMMERCE_WAREHOUSE(8, "自营电商仓", 2),
    CHANNEL_WEAPP_WAREHOUSE(9, "自营小程序仓", 3),
    CHANNEL_THIRD_PARTY_MINIAPP_WAREHOUSE(10, "第三方小程序仓", 3),
    CHANNEL_OMS_WAREHOUSE(11, "OMS", 3);

    private int code;

    private String name;

    private int parentCode;

    WarehouseSubTypeEnum(int code, String name, int parentCode) {
        this.code = code;
        this.name = name;
        this.parentCode = parentCode;
    }

    public static List<WarehouseSubTypeEnum> getSubListByParentCode(int parentCode) {
        List<WarehouseSubTypeEnum> list = Lists.newArrayList();
        for (WarehouseSubTypeEnum sub : WarehouseSubTypeEnum.values()) {
            if (parentCode == sub.getParentCode()) {
                list.add(sub);
            }
        }
        return list;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getParentCode() {
        return parentCode;
    }

    public void setParentCode(int parentCode) {
        this.parentCode = parentCode;
    }
}

