/**
 * @(#) InventoryBussinessRuntimeException.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;

/**
 * 描述
 *
 * @author 魄罗
 * @since 2.0.0
 */
public class InventoryBusinessRuntimeException extends BizException {
    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误描述
     */
    private String errorMsg;

    public InventoryBusinessRuntimeException(InventoryExceptionCode exceptionCode){
        super(exceptionCode.getCode(), exceptionCode.getMsg());
    }

    public InventoryBusinessRuntimeException(String msg) {
        super(msg);
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public static void parameterError(){
        throw new InventoryBusinessRuntimeException(InventoryExceptionCode.PARAMETER_ERROR);
    }

    public static void recordNotExist(){
        throw new InventoryBusinessRuntimeException(InventoryExceptionCode.RECORD_NOT_EXIST);
    }

    public static void recordDuplicated(){
        throw new InventoryBusinessRuntimeException(InventoryExceptionCode.RECORD_DUPLICATED);
    }

    public static void systemInternalError(){
        throw new InventoryBusinessRuntimeException(InventoryExceptionCode.SYSTEM_INTERNAL_ERROR);
    }

}
