/**
 * @(#) InventoryExceptionCode.java 1.0 2018-08-31
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.exception;

/**
 * 库存中心业务异常枚举
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum InventoryExceptionCode {
    SYSTEM_INTERNAL_ERROR("10001", "系统内部错误"),
    PARAMETER_ERROR("10002", "业务参数异常"),
    RECORD_DUPLICATED("11001", "记录重复"),

    RECORD_NOT_EXIST("11002", "记录不存在"),
    CARGO_NOT_ENOUGH("11003", "货品库存不足"),

    CHANGE_LOG_NOT_EXIST("11004", "货品库存变更不存在"),
    TEMPLATE_NOT_EXIST("11005","运费模板不存在"),
    SERVICE_AREA_NOT_EXIST("11006","服务区不存在"),
    STORAGE_CHECK("11007", "该货品正在盘点中"),
    ORDER_NO_EXISTS("11008", "出/入库单已存在"),
    ORDER_EXISTS("11009", "交易订单号已存在"),
    WAREHOUSE_INFO_NOT_EXISTS("11010", "未查询到仓库信息"),
    CARGO_NUM_CAN_NOT_ZERO("11011", "要扣减货品数目不能为零"),
    FREIGHT_FAIL_ID_NOT_EXISTS("11012", "运费计算失败，运费模版ID为空"),
    FREIGHT_FAIL_CAN_NOT_FIND("11013", "运费计算失败，未查询到对应的运费模版"),
    SHIPPING_NO_NOT_NULL("11014", "出库包裹运费单号不能为空"),
    REPEAT_CONFIRM("11015", "不能重复确认出库单"),
    PACKAGE_STATUS_ERROR("11016", "出库包裹状态不正确"),
    CARGO_NOT_EXIST("11017", "货品不存在"),
    WARE_HOUSE_ID_ERR("11018", "仓库实例和租户和入/出不一致"),
    NUM_NOT_NULL("11019", "数量不能为空"),

    OVER_ONE("11020", "一个租户和一个实例只包含一个总仓"),
    WARE_HOUSE_EXIT("11021", "该仓库已经存在货品，不能直接删除"),
    WARE_HOUSE__NULL("11022", "找不到该实例的仓库"),
    CARGO_NOT_SPLIT("11023", "货品找不到仓库配置"),

    WARE_HOUSE_ID_CHECK("11024", "货品配置类型跟仓库类型不一致"),

    SPLIT_CONFIG_NOT_EXIST("11025", "仓库配置不存在"),
    PACKAGE_CONFIG_NOT_EXIST("11026", "拆包配置不存在"),
    POSITION_NOT_NULL("11027", "找不到该位置信息"),
    CODE_DUPLICATED("110028", "编码已经被占用"),
    CONFIG_NOT_EXIT("11029", "库存配置不存在"),
    WARE_HOUSE_ID_ERR_DETAIL("11030", "仓库实例和租户和入/出库明细不一致"),
    WARE_HOUSE_NULL("11031", "找不到该仓库"),
    CARGO_NOT_ENOUGH_INFO("11032", "货品库存信息不存在"),
    SEND_OUT_CARGO_NUM_MORE_THAN_PACKAGE_NUM("11033", "出库货品数量大于包裹货品数量"),
    SEND_OUT_CARGO_NUM_LESS_THAN_ONE("11034", "出库货品数量小于1"),
    WAREHOUSE_CODE_EXIST("11035", "仓库编码已存在"),
    STORAGE_ADJUST_NOT_EXIST("11036","库存调整记录不存在"),
    STORAGE_ADJUST_AUDIT_STATUS_ERROR("11037","库存调整审核状态不正确"),
    STORAGE_ADJUST_NUM_IS_NULL("11038","库存调整数量为空，请先填写要调整数量"),

    ROUTE_RULE_NAME_UNIQUE_ERROR("11051","该路由规则名称已存在，请重新输入"),
    APPLICABLE_CHANNELS_UNIQUE_ERROR("11052","该适用渠道已被选择，请重新选择"),
    INVENTORY_PRIORITY_ITEM_EMPTY_ERROR("11053","库存优先级开启情况下，库存优先级列表不能为空！"),
    WEIGHT_TOTAL_ERROR("11054","请重新调整权重项占比，权重占比总和必须为100！"),
    WEIGHT_ITEM_UNIQUE_ERROR("11055","插入了重复的权重项，请确认权重项不能重复插入！"),
    ORDER_RULE_EMPTY_ERROR("11056","根据主键id查不到该订单路由规则信息"),
    STORAGE_OBJECT_EMPTY_ERROR("11057","根据主键id查不到该库存对象信息"),
    STORAGE_OBJECT_NAME_UNIQUE_ERROR("11058","该库存对象名称已存在，请重新输入"),
    WAREHOUSE_EXPRESS_DELIVER_AREA_NULL_ERROR("11059", "仓库的快递配送区域不能为空"),
    WAREHOUSE_CITY_DELIVERY_GEO_FENCE_NULL_ERROR("11060", "仓库的同城配送地理围栏不能为空"),
    WAREHOUSE_THIRD_PARTY_DELIVERY_NULL_ERROR("11061", "仓库的第三方配送信息不能为空"),

    CARGO_STORAGE_SHARE_TASK_INSERT_FALSE("11062", "货品库存共享任务插入异常"),

    WARE_HOUSE_DISABLED("11070", "仓库为非正常状态，不可以出入库");
    ;
    private final String code;

    private final String msg;

    InventoryExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
