package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IAsynCargoStorageShareApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageShareDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageShareTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageShareTaskRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IAsynShareTaskQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 异步货品库存共享任务Rest
 *
 * @ClassName AsynShareTaskRest
 * @Author chunjiu
 * @Date 2020/9/15 20:01
 */
@Component
public class AsynShareTaskFallBack implements IAsynShareTaskQueryApi, IAsynCargoStorageShareApi {


    @Override
    public RestResponse<PageInfo<CargoStorageShareTaskRespDto>> queryByPage(@RequestBody CargoStorageShareTaskReqDto taskReqDto,
                                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<CargoStorageShareTaskRespDto> queryById(@NotNull(message = "任务id不能为空") @PathVariable("id") Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public boolean asynCreateShareTask(@RequestBody CargoStorageShareDto shareDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
