/*
 * CargoRest.class 1.0 2018-08-31
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import java.util.List;

/**
 * 货品管理REST接口
 *
 * @author 纳兰
 * @since 2.0.0
 */
@Component
public class CargoFallBack implements ICargoApi, ICargoQueryApi {
    @Resource
    ICargoApi cargoApi;
    @Resource
    ICargoQueryApi cargoQueryApi;

    @Override
    public RestResponse<Long> addCargo(@RequestBody CargoCreateReqDto cargoCreateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyCargo(@RequestBody CargoUpdateReqDto cargoUpdateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> removeById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> removeByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<CargoRespDto> queryById(@PathVariable("id") Long id, @RequestParam(name = "filter", required = false) String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<CargoRespDto> queryByCode(@PathVariable("code") String code, @RequestParam(name = "filter", required = false) String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<CargoRespDto>> listByCodes(@RequestBody List<String> cargoCodes) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<CargoRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                            @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<CargoRespDto>> queryByList(@RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
