/*
 * @(#)CargoOrderDeliveryRest.java 1.0 2018-11-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderPackageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author 简树
 * @since 2.0.0
 */
@Component
public class CargoOrderDeliveryFallBack implements ICargoOrderDeliveryQueryApi {

    @Override
    public RestResponse<List<OrderPackageRespDto>> queryStorageOutPackage(@PathVariable("orderNos") String[] orderNos) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<OrderPackageRespDto>> queryPackage(@PathVariable String[] orderNos) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<PackageShippingLogRespDto>> queryPackageLog(@PathVariable("orderNo") String orderNo) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

}