/**
 * @(#) CargoStorageRest.java 1.0 2018-09-06
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoStorageApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.UpdateStorageSynNumReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoStorageQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 描述
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Component
public class CargoStorageFallBack implements ICargoStorageApi, ICargoStorageQueryApi {

    @Override
    public RestResponse<Void> subCargoStorage(@RequestBody CargoStorageCreateReqDto cargoStorageReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyCargoStorage(@PathVariable("id") Long id,
                                                 @RequestBody CargoStorageUpdateReqDto cargoStorageUpdateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> resetCargoStorage(@RequestBody CargoStorageRestReqDto cargoStorageRestReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<CargoStorageQueryRespDto> queryCargoStorage(@RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<CargoStorageQueryRespDto> queryCargoStorageExt(CargoStorageQueryReqDto cargoStorageQueryReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<CargoStorageDetailQueryRespDto>> queryCargoStorageDetail(@RequestParam("filter") String filter,
                                                                                          @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                          @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> coverCargoStorage(StorageAdjustCoverReqDto storageAdjustCoverReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> confirmPreempt(CargoStoragePreemptConfirmReqDto preemptConfirmReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> updateStorageSynNum(@RequestBody List<UpdateStorageSynNumReqDto> synStorageUpdateNumReqDtoList) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
