/**
 * @(#) DeliveryOrderRest.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IDeliveryOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryOrderGenerateReqDto;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 描述
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Component
public class DeliveryOrderFallBack implements IDeliveryOrderApi {


    @Override
    public RestResponse<Void> generateDelivery(@RequestBody String deliveryOrderJson) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> generateDelivery(DeliveryOrderGenerateReqDto deliveryOrderGenerateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
