/*
 * @(#)InventoryException.java 1.0 2018-09-07
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForCustomerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForOperatorRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IFreightQueryApi;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 运费Rest
 *
 * @author 佐助
 * @since 2.0.0
 */
@Component
public class FreightFallBack implements IFreightQueryApi {


    /**
     * 消费端：根据订单列表查询运费
     *
     * @param filter 业务参数封装对象JSON
     * @return FreightForCustomerRespDto集合 订单运费列表
     */
    @Override
    public RestResponse<List<FreightForCustomerRespDto>> queryByCustomer(@RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 管理端：根据货品列表查询运费
     *
     * @param filter 业务参数封装对象JSON
     * @return FreightForOperatorRespDto 货品运费
     */
    @Override
    public RestResponse<FreightForOperatorRespDto> queryByOperator(@RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}