package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IOrderRouteRuleApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IOrderRouteRuleQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;

import javax.validation.Valid;

/**
 * @author: liuji
 * @Date: 2020-06-22 14:33
 * @since 2.0.0
 */
@Component
public class OrderRouteRuleFallBack implements IOrderRouteRuleApi, IOrderRouteRuleQueryApi {


    @Override
    public RestResponse<String> saveRouteRule(@Valid OrderRouteRuleReqDto orderRouteRuleReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<String> enOrDisableRouteRule(Long id, Integer status) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<OrderRouteRuleRespDto>> queryRouteRulesByPage(OrderRouteRuleQueryReqDto orderRouteRuleQueryReqDto, Integer pageNum, Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<OrderRouteRuleRespDto> queryRouteRuleById(Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
