/*
 * PackageRest.class 1.0 2018-09-13
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.IPackageApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageSplitConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IPackageQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.Max;
import java.util.List;

/**
 * 包裹管理Rest接口
 *
 * @author 纳兰
 * @since 2.0.0
 */
@Component
public class PackageFallBack implements IPackageApi, IPackageQueryApi {

    @Override
    public RestResponse<Void> modifyPackage(@RequestBody PackageReqDto packageReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);

    }

    @Override
    public RestResponse<PackageRespDto> queryPackageById(@PathVariable("deliveryOrderId") Long deliveryOrderId) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyPackage(@PathVariable("id") Long id, @RequestBody PackageModReqDto packageDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> packed(@PathVariable("id") Long id, @RequestBody PackagePackedReqDto packedReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 新增拆包配置
     *
     * @param packageSplitConfigCreateReqDto 拆包配置请求Dto
     * @return Long
     */
    @Override
    public RestResponse<Long> addPackageSplitConfig(@RequestBody PackageSplitConfigCreateReqDto packageSplitConfigCreateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 修改拆包配置信息
     *
     * @param id                             主键id
     * @param packageSplitConfigUpdateReqDto 拆包配置更新Dto
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> modifyPackageSplitConfig(@PathVariable("id") Long id,
                                                       @RequestBody PackageSplitConfigUpdateReqDto packageSplitConfigUpdateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }


    /**
     * 根据id删除配置信息
     *
     * @param id     拆包配置id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeConfigById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据code删除配置信息
     *
     * @param code   编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeConfigByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据id查询拆包配置详情
     *
     * @param id     拆包配置id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return PackageSplitConfigRespDto
     */
    @Override
    public RestResponse<PackageSplitConfigRespDto> queryConfigById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据code查询拆包配置详情
     *
     * @param code   编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return PackageSplitConfigRespDto
     */
    @Override
    public RestResponse<PackageSplitConfigRespDto> queryConfigByCode(@PathVariable("code") String code,
                                                                     @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据条件查询拆包配置分页列表
     *
     * @param filter   查询条件
     * @param pageNum  指定页码
     * @param pageSize 页大小
     * @return PackageSplitConfigRespDto分页信息
     */
    @Override
    public RestResponse<PageInfo<PackageSplitConfigRespDto>> queryConfigByPage(@RequestParam(name = "filter", required = false) String filter,
                                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                               @Max(value = 100, message = "最大值不能超过100")
                                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据分组id查询拆包配置列表
     *
     * @param groupId 分组id
     * @param filter  {"instanceId":0,"tenantId":1}
     * @return PackageSplitConfigRespDto集合
     */
    @Override
    public RestResponse<List<PackageSplitConfigRespDto>> queryConfigByGroupId(@PathVariable("groupId") Long groupId,
                                                                              @RequestParam("filter") String filter) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PackageShippingLogRespDto> queryPackLogById(@PathVariable("id") Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
