package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IRuleApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RulePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RuleReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IRuleQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 库存规则Rest类
 */
@Component
public class RuleFallBack implements IRuleApi, IRuleQueryApi {


    @Override
    public RestResponse<Long> addRule(@RequestBody RuleReqDto ruleDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyRule(@RequestBody RuleReqDto ruleDto) {

        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> removeRule(@PathVariable("ids") String ids) {

        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<RuleRespDto> queryById(@PathVariable("id") Long id) {

        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<RuleRespDto>> queryByIds(List<Long> ruleIds) {

        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }


    @Override
    public RestResponse<PageInfo<RuleRespDto>> queryByPage(@ModelAttribute RulePageReqDto rulePageReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}