/**
 * @(#)ShippingRest.java 1.0 2018年9月7日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.IShippingApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IShippingQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import javax.validation.constraints.Max;
import java.util.List;

/**
 * 物流Rest
 *
 * @author 水镜
 * @since 2.0.0
 */
@Component
public class ShippingFallBack implements IShippingApi, IShippingQueryApi {

    @Resource
    private IShippingApi shippingApi;

    @Resource
    private IShippingQueryApi shippingQueryApi;

    @Override
    public RestResponse<String> queryLogByShippingNo(@PathVariable("shippingNo") String shippingNo) {
        return shippingQueryApi.queryLogByShippingNo(shippingNo);
    }

    /**
     * 新增物流公司
     *
     * @param shippingCompanyCreateReqDto 物流公司创建Dto
     * @return Long
     */
    @Override
    public RestResponse<Long> addShippingCompany(@RequestBody ShippingCompanyCreateReqDto shippingCompanyCreateReqDto) {
        return shippingApi.addShippingCompany(shippingCompanyCreateReqDto);
    }

    /**
     * 修改物流公司信息
     *
     * @param shippingCompanyUpdateReqDto 物流公司更新Dto
     * @param id 物流公司ID
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> modifyShippingCompany(@RequestBody ShippingCompanyUpdateReqDto shippingCompanyUpdateReqDto, @PathVariable("id") Long id) {
        return shippingApi.modifyShippingCompany(shippingCompanyUpdateReqDto, id);
    }

    /**
     * 根据id删除物流公司信息
     *
     * @param id 物流公司id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeCompanyById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingApi.removeCompanyById(id, filter);
    }

    /**
     * 根据code删除物流公司信息
     *
     * @param code 物流公司编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeCompanyByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        return shippingApi.removeCompanyByCode(code, filter);
    }

    /**
     * 根据id查询物流公司信息
     *
     * @param id 物流公司id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingCompanyRespDto
     */
    @Override
    public RestResponse<ShippingCompanyRespDto> queryCompanyById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryCompanyById(id, filter);
    }

    /**
     * 根据code查询物流公司信息
     *
     * @param code 物流公司code
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingCompanyRespDto
     */
    @Override
    public RestResponse<ShippingCompanyRespDto> queryCompanyByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryCompanyByCode(code, filter);
    }


    /**
     * 根据条件查询物流公司分页列表
     *
     * @param filter   查询条件
     * @param pageNum  指定页
     * @param pageSize 页大小
     * @return ShippingCompanyRespDto分页信息
     */
    @Override
    public RestResponse<PageInfo<ShippingCompanyRespDto>> queryCompanyByPage(@RequestParam(name = "filter", required = false) String filter,
                                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                             @Max(value = 100, message = "最大值不能超过100")
                                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        return shippingQueryApi.queryCompanyByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<Void> addShippingPartner(@RequestBody ShippingPartnerCreateReqDto shippingPartnerCreateReqDto) {
        return shippingApi.addShippingPartner(shippingPartnerCreateReqDto);
    }

    @Override
    public RestResponse<Void> modifyShippingPartnerById(@PathVariable("id") Long id, @RequestBody ShippingPartnerUpdateReqDto shippingPartnerUpdateReqDto) {
        return shippingApi.modifyShippingPartnerById(id, shippingPartnerUpdateReqDto);
    }

    @Override
    public RestResponse<Void> removePartnerById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingApi.removePartnerById(id, filter);
    }

    @Override
    public RestResponse<Void> addShippingPartnerConfig(@RequestBody ShippingPartnerConfigCreateReqDto shippingPartnerConfigCreateReqDto) {
        return shippingApi.addShippingPartnerConfig(shippingPartnerConfigCreateReqDto);
    }

    @Override
    public RestResponse<Void> modifyShippingPartnerConfigById(@PathVariable("id") Long id, @RequestBody ShippingPartnerConfigUpdateReqDto shippingPartnerConfigUpdateReqDto) {
        return shippingApi.modifyShippingPartnerConfigById(id, shippingPartnerConfigUpdateReqDto);
    }

    @Override
    public RestResponse<Void> removeConfigById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingApi.removeConfigById(id, filter);
    }

    @Override
    public RestResponse<ShippingPartnerRespDto> queryPartnerById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryPartnerById(id, filter);
    }

    @Override
    public RestResponse<ShippingPartnerConfigRespDto> queryConfigById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryConfigById(id, filter);
    }

    /**
     * 新增运费模板与规则
     *
     * @param shippingTemplateCreateReqDto 运费模板与规则请求参数Dto
     * @return 操作结果
     */
    @Override
    public RestResponse<Long> addShippingTemplateAndRule(@RequestBody ShippingTemplateCreateReqDto shippingTemplateCreateReqDto) {
        return shippingApi.addShippingTemplateAndRule(shippingTemplateCreateReqDto);
    }

    /**
     * 修改运费模板与规则
     *
     * @param id                           运费模板id
     * @param shippingTemplateUpdateReqDto 运费模板与规则修改Dto
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> modifyTemplateAndRule(@PathVariable("id") Long id, @RequestBody ShippingTemplateUpdateReqDto shippingTemplateUpdateReqDto) {
        return shippingApi.modifyTemplateAndRule(id, shippingTemplateUpdateReqDto);
    }

    /**
     * 根据id删除运费模板与规则
     *
     * @param id 运费模板id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeTemplateById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingApi.removeTemplateById(id, filter);
    }

    /**
     * 根据code删除运费模板与规则
     *
     * @param code 编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeTemplateByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        return shippingApi.removeTemplateByCode(code, filter);
    }

    /**
     * 运费模板与地区关联
     *
     * @param rTtemplateAreaReqDto 运费模板与地区关联Dto
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> addRelationToArea(@RequestBody RTtemplateAreaReqDto rTtemplateAreaReqDto) {
        return shippingApi.addRelationToArea(rTtemplateAreaReqDto);
    }

    /**
     * 根据运费模板id删除关联关系
     *
     * @param id 运费模板id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @Override
    public RestResponse<Void> removeRelationByShippingTplId(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingApi.removeRelationByShippingTplId(id, filter);
    }

    /**
     * 根据id查询运费模板与规则
     *
     * @param id 运费模板id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingTemplateRespDto
     */
    @Override
    public RestResponse<ShippingTemplateRespDto> queryTemplateById(@PathVariable("id") Long id, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryTemplateById(id, filter);
    }

    /**
     * 根据code查询运费模板与规则
     *
     * @param code 编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingTemplateRespDto
     */
    @Override
    public RestResponse<ShippingTemplateRespDto> queryTemplateByCode(@PathVariable("code") String code, @RequestParam("filter") String filter) {
        return shippingQueryApi.queryTemplateByCode(code, filter);
    }

    /**
     * 根据分组id查询运费模板与规则
     *
     * @param groupId 分组id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingTemplateRespDto集合
     */
    @Override
    public RestResponse<List<ShippingTemplateRespDto>> queryTemplateByGroupId(@PathVariable("groupId") Long groupId,
                                                                              @RequestParam("filter") String filter) {
        return shippingQueryApi.queryTemplateByGroupId(groupId, filter);
    }

    /**
     * 根据服务区id查询运费模板与规则
     *
     * @param serviceAreaId 服务区id
     * @param filter {"instanceId":0,"tenantId":1}
     * @return ShippingTemplateRespDto集合
     */
    @Override
    public RestResponse<List<ShippingTemplateRespDto>> queryTemplateByServiceAreaId(@PathVariable("serviceAreaId") Long serviceAreaId,
                                                                                    @RequestParam("filter") String filter) {
        return shippingQueryApi.queryTemplateByServiceAreaId(serviceAreaId, filter);
    }

    /**
     * 根据条件查询 运费模板与规则 分页列表
     *
     * @param filter   查询条件
     * @param pageNum  指定页
     * @param pageSize 页大小
     * @return ShippingTemplateRespDto分页信息
     */
    @Override
    public RestResponse<PageInfo<ShippingTemplateRespDto>> queryTemplateByPage(@RequestParam(name = "filter", required = false) String filter,
                                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                               @Max(value = 100, message = "最大值不能超过100")
                                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        return shippingQueryApi.queryTemplateByPage(filter, pageNum, pageSize);
    }

}
