package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageAdjustApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustCoverReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageAdjustQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 库存调整
 *
 * @author: liuji
 * @Date: 2020-07-20 10:09
 * @since 2.0.0
 */
@Component
public class StorageAdjustFallBack implements IStorageAdjustApi, IStorageAdjustQueryApi {


    @Override
    public RestResponse<String> addStorageAdjust(@Valid StorageAdjustReqDto storageAdjustReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyStorageAdjust(Long id, @Valid StorageAdjustReqDto storageAdjustReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> commitStorageAdjust(Long id) {

        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> auditStorageAdjust(Long id, @Valid @RequestBody StorageAdjustAuditReqDto storageAdjustAuditReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<StorageAdjustRespDto>> queryStorageAdjustByPage(StorageAdjustQueryReqDto storageAdjustQueryReqDto, Integer pageNum, Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<StorageAdjustRespDto> queryStorageAdjustById(Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<StorageAdjustCargoRespDto>> queryAdjustCargoByStorageAdjustNo(String no, Integer pageNum, Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> storageAdjustCover(StorageAdjustCoverReqDto storageAdjustCoverReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
