package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageObjectApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageObjectRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageObjectQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;

import javax.validation.Valid;

/**
 * @author: liuji
 * @Date: 2020-07-03 11:36
 * @since 2.0.0
 */
@Component
public class StorageObjectFallBack implements IStorageObjectQueryApi, IStorageObjectApi {


    @Override
    public RestResponse<String> saveStorageObject(@Valid StorageObjectReqDto storageObjectReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<StorageObjectRespDto>> queryStorageObjectByPage(StorageObjectQueryReqDto dto, Integer pageNum, Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<StorageObjectRespDto> queryStorageObjectById(Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
