/*
 * @(#)StorageOrderRest.java 1.0 2018-08-30
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageByPackageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.*;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 出入库单Rest接口
 *
 * @author 书生
 * @since 2.0.0
 */
@Component
public class StorageOrderFallBack implements IStorageOrderApi, IStorageOrderQueryApi {


    /**
     * 新增出入库单
     *
     * @param dto 入库、出库新增的参数
     * @return Long 返回新增的ID
     */
    @Override
    public RestResponse<Long> addStorageOrder(@RequestBody StorageOrderCreateDto dto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> auditStorageOrder(@PathVariable Long id, @RequestParam Integer status, @RequestParam String name) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> cancelOutStorageOrder(OutStorageCancelReqDto reqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }


    @Override
    public RestResponse<Void> outStorageOrder(OutStorageOutReqDto reqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<List<StorageCheckRespDto>> deliverStorageOrder(DeliverStorageReqDto reqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> cancelInStorageOrder(InStorageCancelReqDto reqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> inStorageOrder(InStorageInReqDto reqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Long> addStorageOrderByPackageAndCargo(List<PackageDetailDto> packageDetailDtoList) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> modifyStorageOrder(@RequestBody StorageOrderCreateDto storageOrderReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据ID查询出入库单信息
     *
     * @param id 出入库单ID
     * @return CargoStorageEo入库单
     */
    @Override
    public RestResponse<StorageOrderCombineRespDto> queryById(@PathVariable("id") Long id) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    /**
     * 根据入库单ID查询入库单信息Eo
     *
     * @param filter   查询条件，json字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return StorageOrderCombineRespDto 出入库单Dto分页列表
     */
    @Override
    public RestResponse<PageInfo<StorageOrderCombineRespDto>> queryFilterByPage(@RequestParam("filter") String filter,
                                                                                @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<PageInfo<StorageOrderRespDto>> queryByPage(@ModelAttribute StorageOrderPageReqDto storageOrderPageReqDto,
                                                                   @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
