package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseCargoApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseCargoQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * 仓库货品服务
 *
 * @author: 浮云
 * @Date: 2020/7/21 17:03
 */
@Component
public class WarehouseCargoFallBack implements IWarehouseCargoApi, IWarehouseCargoQueryApi {


    @Override
    public RestResponse<Void> batchAdd(@RequestBody WarehouseCargoCreateReqDto warehouseCargoCreateReqDto) {

        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<WarehouseCargoRespDto>> page(@ModelAttribute WarehouseCargoReqDto warehouseCargoReqDto,
                                                              @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);

    }

    @Override
    public RestResponse<Void> updateInventoryShareStatus(@RequestParam("id") Long id,
                                                         @RequestParam("inventoryShareStatus") Integer inventoryShareStatus) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> subCargoStorage(@Valid @RequestBody CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }

    @Override
    public RestResponse<Void> checkCargoStorage(@RequestBody CargoStorageCheckReqDto cargoStorageCheckReqDto) {
        throw new BizException(FallBackContant.FALL_BACK_ERR);
    }
}
