package com.dtyunxi.yundt.cube.center.inventory.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IRServiceAreaApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.*;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Component;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Component
public class WarehouseFallBack implements IWarehouseApi, IWarehouseQueryApi, IRServiceAreaApi {
    @Override
    public RestResponse<Long> add(@Valid RServiceAreaReqDto rServiceAreaReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Long> addWarehouse(@Valid WarehouseCreateReqDto warehouseCreateReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> modifyWarehouse(@NotNull(message = "仓库id不能为空") Long id, @Valid WarehouseUpdateReqDto warehouseUpdateReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeWarehouseByCode(@NotNull(message = "仓库code不能为空") String code, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeWarehouseById(@NotNull(message = "仓库id不能为空") Long id) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeWarehouseByServiceAreaId(@NotNull(message = "服务区ID不能为空") Long serviceAreaId, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeWarehouseByIds(@NotNull(message = "仓库ID列表不能为空") String ids, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Long> relateToServiceArea(@Valid RAreaWarehouseReqDto rAreaWarehouseReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeRelation(@NotNull(message = "仓库ID列表不能为空") String ids, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Long> addPosition(@Valid PositionCreateReqDto positionCreateReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> modifyPosition(@NotNull(message = "仓位ID不能为空") Long id, @Valid PositionUpdateReqDto positionUpdateReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removePositionById(@NotNull(message = "仓位ID不能为空") Long id, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removePositionByCode(@NotNull(message = "仓位code不能为空") String code, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> addServiceArea(@Valid ServiceAreaCreateDto serviceAreaCreateDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> modifyServiceArea(@NotNull(message = "服务区id不能为空") Long id, @Valid ServiceAreaUpdateDto serviceAreaUpdateDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> removeServiceAreaById(@NotNull(message = "服务区id不能为空") Long id, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> switchInventoryShareStatus(Long id, Integer status) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public Integer addCreditValue(String warehouseCode, Integer changeValue) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<WarehouseRespDto> queryWarehouseById(@NotNull(message = "仓库Id不能为空") Long id, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<WarehouseRespDto> queryWarehouseBaseById(@NotNull(message = "仓库Id不能为空") Long id) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<WarehouseRespDto> queryWarehouseByCode(@NotBlank(message = "仓库code不能为空") String code, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehouseByPage(String filter, Integer pageNum, @Max(value = 100, message = "最大值不能超过100") Integer pageSize) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<List<WarehouseRespDto>> queryWarehouseByGroupId(@NotNull(message = "分组id不能为空") Long groupId, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PositionQueryRespDto> queryPositionById(@NotNull(message = "仓位id不能为空") Long id, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PositionQueryRespDto> queryPositionByCode(@NotNull(message = "仓位编码不能为空") String code, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<List<PositionQueryRespDto>> queryPositionByList(String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PageInfo<PositionQueryRespDto>> queryPositionByPage(String filter, Integer pageNum, @Max(value = 100, message = "最大值不能超过100") Integer pageSize) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<ServiceAreaRespDto> queryServiceAreaById(@NotNull(message = "服务区id不能为空") Long id, String filter) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PageInfo<ServiceAreaRespDto>> queryServiceAreaByPage(String filter, Integer pageNum, @Max(value = 100, message = "最大值不能超过100") Integer pageSize) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehousePage(WarehouseQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<PageInfo<WarehouseRespDto>> queryByLogAndLat(WarehouseCoordinateQueryReqDto coordinateQueryReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<List<WarehouseDeliveryQueryRespDto>> queryWarehouseDeliveryList(Long warehousesId) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<List<WarehouseTypeDto>> queryWarehouseType(Integer parentCode) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> lockWarehouse(WarehouseLockReqDto warehouseLockReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<Void> unlockWarehouse(WarehouseUnLockReqDto warehouseUnLockReqDto) {
        throw new BizException("未开启库存中心服务");
    }

    @Override
    public RestResponse<List<WarehouseRespDto>> queryListByCodes(List<String> codes) {
        throw new BizException("未开启库存中心服务");
    }
}
