package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteCountReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRecordRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.DeliveryRouteFallBack;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.WarehouseFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 发货单路由查询api
 *
 * @author: fuyun
 * @Date: 2020/9/4 17:17
 */
@Api(tags = {"库存中心：路由服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/delivery/route",fallback = DeliveryRouteFallBack.class)
public interface DeliveryRouteQueryApi {

    /**
     * 查询路由次数
     *
     * @param deliveryRouteCountReqDto 请求dto
     * @return
     */
    @PostMapping(value = "/countRouteRecord/count")
    @ApiOperation(value = "计算路由次数", notes = "计算路由次数")
    RestResponse<Integer> countRouteRecord(@RequestBody DeliveryRouteCountReqDto deliveryRouteCountReqDto);

    /**
     * 查询发货单路由日志列表
     *
     * @param deliveryRouteRecordReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/routeRecord/query")
    @ApiOperation(value = "查询发货单路由日志列表", notes = "查询发货单路由日志列表")
    RestResponse<PageInfo<DeliveryRouteRecordRespDto>> queryRouteRecord(@ModelAttribute DeliveryRouteRecordReqDto deliveryRouteRecordReqDto,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

     /**
     * 根据渠道查询已启用路由规则
     *
     * @param channel 渠道编码
     * @return
     */
    @PostMapping(value = "/queryOrderRouteRule")
    @ApiOperation(value = "根据渠道查询已启用路由规则", notes = "根据渠道查询已启用路由规则")
    RestResponse<OrderRouteRuleRespDto> queryOrderRouteRule(@RequestParam(value = "channel") String channel);
}
