package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageShareTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageShareTaskRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.AsynShareTaskFallBack;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.DeliveryRouteFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 异步货品库存共享任务Api
 *
 * @Interface IAsynShareTaskQueryApi
 * @Author chunjiu
 * @Date 2020/9/15 19:51
 */
@Api(tags = {"库存中心：异步货品库存共享任务服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/task",fallback = AsynShareTaskFallBack.class)
public interface IAsynShareTaskQueryApi {

    /**
     * 分页查询共享任务
     *
     * @param taskReqDto 共享任务请求参数
     * @param pageNum 指定页码
     * @param pageSize 指定每页返回的对象个数
     * @return 分页信息 共享任务分页列表
     **/
    @GetMapping(value = "/page")
    @ApiOperation(value = "获取共享任务分页列表", notes ="获取共享任务分页列表")
    RestResponse<PageInfo<CargoStorageShareTaskRespDto>> queryByPage(@RequestBody CargoStorageShareTaskReqDto taskReqDto,
                                                                     @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据任务id查询共享任务详情
     *
     * @param id 任务id
     * @return CargoRespDto
     **/
    @GetMapping("/{id}")
    @ApiOperation(value = "根据任务id查询共享任务详情", notes = "id，未启用")
    RestResponse<CargoStorageShareTaskRespDto> queryById(@NotNull(message = "任务id不能为空") @PathVariable("id") Long id);
}
