package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillPageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RulePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BillCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BillRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
* 库存单据服务接口
*/
@Api(tags = {"库存单据服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/bill")
public interface IBillQueryApi {

    /**
    * 根据id查询库存单据
    *
    * @param id 库存单据id
    * @return   库存单据数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存单据", notes = "根据id查询库存单据")
    RestResponse<BillCombineRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 根据idS查询库存单据
    *
    * @param billIds 配件id
    * @return   库存单据数据
    */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询库存单据", notes = "根据ids查询库存单据")
    RestResponse<List<BillCombineRespDto>> queryByIds(@RequestBody List<Long> billIds);
    
    /**
    * 库存单据分页数据
    *
    * @param billPageReqDto   库存单据查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 库存单据分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "库存单据分页数据", notes = "根据filter查询条件查询库存单据数据，filter=BillRespDto")
    RestResponse<PageInfo<BillRespDto>> queryByPage(@ModelAttribute BillPageDto billPageReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

}
