/*
 * @(#)ICargoOrderDeliveryQueryApi.java 1.0 2018-11-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderPackageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.AsynShareTaskFallBack;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.CargoOrderDeliveryFallBack;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;

import java.util.List;

/**
 * 外部订单查询服务
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = {"库存中心：外部订单服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/order/",fallback = CargoOrderDeliveryFallBack.class)
public interface ICargoOrderDeliveryQueryApi {
    /**
     * 因in_delivery_order表和in_delivery_order_detail表废除,移除相关代码,此接口逻辑可能不正确
     * 根据订单号查询已发货、已签收的包裹和包裹明细信息
     * @param orderNos 订单号列表
     * @return 包裹信息
     */
    @Deprecated
    @PutMapping("/package/orderNo/{orderNos}")
    @ApiOperation(value = "根据订单号查询已经出库的包裹", notes = "根据订单号查询已发货、已签收的包裹和包裹明细信息")
    RestResponse<List<OrderPackageRespDto>>queryStorageOutPackage(@PathVariable("orderNos") String[] orderNos);

    /**
     * 据订单号查询的包裹
     * @param orderNos 订单号列表
     * @return 包裹信息
     */
    @GetMapping("/package/all/orderNo/{orderNos}")
    @ApiOperation(value = "根据订单号查询包裹信息", notes = "根据订单号查询所有状态的包裹和包裹明细信息")
    RestResponse<List<OrderPackageRespDto>>queryPackage(@PathVariable("orderNos") String[] orderNos);

    /**
     * 根据订单号查询包裹物流信息
     * @param orderNo 订单号
     * @return 物流信息
     */
    @GetMapping("/package/log/orderNo/{orderNo}")
    @ApiOperation(value = "根据订单号查询包裹物流信息", notes = "根据订单号查询包裹物流信息")
    RestResponse<List<PackageShippingLogRespDto>>queryPackageLog(@PathVariable("orderNo")String orderNo);


}
