/**
 * @(#) ICargoStorageQueryApi.java 1.0 2018-09-05
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.AsynShareTaskFallBack;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.CargoStorageFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 货品库存查询服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"库存中心：货品库存查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/cargo/storage", fallback = CargoStorageFallBack.class)
public interface ICargoStorageQueryApi {

    /**
     * 消费端：货品库存数量查询
     *
     * @param filter 业务参数封装对象JSON，仓库ID或者省市区编码，必须提供一种
     * @return CargoStorageQueryRespDto 查询货品库存数量集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "消费端：货品库存数量查询", notes = "消费端：货品库存数量查询。如果请求参数没有提供仓库ID，则省市区编码必填：\n"
            + "filter=CargoStorageQueryReqDto={\r\n"
            + "\"provCode\": \"String:省编码:必填\",\r\n\"cityCode\": \"String:市编码:必填\",\r\n\"areaCode\": \"String:区域编码:必填\",\r\n\""
            + "cargoStorageList\":[\r\n{\r\n\"cargoId\":\"Long:货品ID:必填\",\r\n\"warehouseId\":\"Long:仓库ID:选填\"\r\n}\r\n],\r\n\""
            + "instanceId\":\"Long:实例ID:必填\",\r\n\"tenantId\":\"Long:租户ID:必填\"\r\n}")
    RestResponse<CargoStorageQueryRespDto> queryCargoStorage(@RequestParam("filter") String filter);


    @PostMapping("/query/list")
    @ApiOperation(value = "消费端：货品库存数量查询", notes = "消费端：货品库存数量查询。如果请求参数没有提供仓库ID，则省市区编码必填：\n"
            + "filter=CargoStorageQueryReqDto={\r\n"
            + "\"provCode\": \"String:省编码:必填\",\r\n\"cityCode\": \"String:市编码:必填\",\r\n\"areaCode\": \"String:区域编码:必填\",\r\n\""
            + "cargoStorageList\":[\r\n{\r\n\"cargoId\":\"Long:货品ID:必填\",\r\n\"warehouseId\":\"Long:仓库ID:选填\"\r\n}\r\n],\r\n\""
            + "instanceId\":\"Long:实例ID:必填\",\r\n\"tenantId\":\"Long:租户ID:必填\"\r\n}")
    RestResponse<CargoStorageQueryRespDto> queryCargoStorageExt(@RequestBody CargoStorageQueryReqDto cargoStorageQueryReqDto);

    /**
     * 管理端：货品库存数量查询
     *
     * @param filter   业务参数封装对象JSON
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return CargoStorageDetailQueryRespDto分页信息 货品库存信息集合
     */
    @GetMapping("/detail/list")
    @ApiOperation(value = "管理端：货品库存数量查询", notes = "管理端：货品库存数量查询:filter=CargoStorageDetailQueryReqDto={\r\n"
            + "\"groupId\":\"Long:分组ID:选填\",\r\n\"warehouseId\":\"Long:仓库ID:选填\",\r\n\"positionId\":\"Long:仓位ID:选填\",\r\n"
            + "\"cargoId\":\"Long:货品ID:选填\",\r\n\"instanceId\":\"Long:实例ID:必填\",\r\n\"tenantId\":\"Long:租户ID:必填\"\r\n}")
    RestResponse<PageInfo<CargoStorageDetailQueryRespDto>> queryCargoStorageDetail(@RequestParam("filter") String filter,
                                                                                   @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                   @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
