package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ChangeLogPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ChangeLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.AsynShareTaskFallBack;
import com.dtyunxi.yundt.cube.center.inventory.api.fallback.ChangeLogFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
* 库存流水服务接口
*/
@Api(tags = {"库存流水服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/changeLog",fallback = ChangeLogFallBack.class)
public interface IChangeLogQueryApi {

    /**
    * 根据id查询库存流水
    *
    * @param id 库存流水id
    * @return   库存流水数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存流水", notes = "根据id查询库存流水")
    RestResponse<ChangeLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 根据idS查询库存流水
    *
    * @param changeLogIds 配件id
    * @return   库存流水数据
    */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询库存流水", notes = "根据ids查询库存流水")
    RestResponse<List<ChangeLogRespDto>> queryByIds(@RequestBody List<Long> changeLogIds);
    
    /**
    * 库存流水分页数据
    *
    * @param changeLogPageReqDto   库存流水查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 库存流水分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "库存流水分页数据", notes = "根据filter查询条件查询库存流水数据，filter=changeLogDto")
    RestResponse<PageInfo<ChangeLogRespDto>> queryByPage(@ModelAttribute ChangeLogPageReqDto changeLogPageReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                         @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 库存流水分页数据,分页1页，默认10000条
     *
     * @param changeLogPageReqDto   库存流水查询条件
     * @return 库存流水分页数据
     */
    @PostMapping("/page/Dto")
    @ApiOperation(value = "库存流水分页数据", notes = "根据filter查询条件查询库存流水数据，分页1页，默认10000条，filter=changeLogDto")
    RestResponse<PageInfo<ChangeLogRespDto>> queryByDto(@RequestBody ChangeLogPageReqDto changeLogPageReqDto);
}
