/**
 * @(#) IDeliveryOrderQueryApi.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryItemSumReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryItemRespDto;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 发货单查询
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"库存中心：发货单查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/delivery-order")
public interface IDeliveryOrderQueryApi {

    @PostMapping("/sum-item")
    RestResponse<List<DeliveryItemRespDto>> sumItem(@RequestBody DeliveryItemSumReqDto deliveryItemSumReqDto);
}
